/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassLoaderRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class NormalClassRenderer
extends MultiEntryRendererBase {
    public static final String IMAGE_TAG = "classObject.image";
    public static final String PACKAGE_TAG = "classObject.package";
    public static final String CLASS_TAG = "classObject.class";
    private final TextNode packageText;
    private final TextNode classText;
    private final TextNode text;
    private final RendererNode root;

    public NormalClassRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} classes"), I18n._s((String)"{0} other classes"), I18n._s((String)"{0} skipped classes"));
        this.packageText = viewer.newTextNode(null);
        this.classText = viewer.newTextNode(null);
        this.text = viewer.newTextNode(null);
        this.root = theme.decorate(IMAGE_TAG, viewer, viewer.newMultiChildNode(viewer.newOrderedMultiChildNode(new int[]{1, 0}, new RendererNode[]{viewer.newAlignNode(1, theme.decorate(PACKAGE_TAG, viewer, this.packageText)), viewer.newAlignNode(1, theme.decorate(CLASS_TAG, viewer, this.classText))})));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalClassPers classEntry;
        NormalClassPers normalClassPers = classEntry = entry instanceof NormalClassPers ? (NormalClassPers)entry : new NormalClassPers(((NormalClass)entry).getClassObject());
        if (classEntry.isNoStack()) {
            this.text.setText(I18n._s((String)"<no stack>"));
            return this.text;
        }
        if (classEntry.isInlinedAway()) {
            this.text.setText(I18n._s((String)"<inlined away>"));
            return this.text;
        }
        String packageName = classEntry.getPackageName();
        String className = classEntry.getName();
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        this.packageText.setText(packageName);
        this.classText.setText(className);
        return this.root;
    }

    public static String getAsString(ClassObject clazz, String indent) {
        StringBuilder result = new StringBuilder(indent);
        result.append(I18n._s((String)"Class:\n"));
        result.append(indent);
        result.append("    ");
        result.append(clazz.getFullName());
        ClassLoaderObject loader = clazz.getClassLoader();
        result.append("\n\n");
        result.append(indent);
        result.append(I18n._s((String)"Class loader:\n"));
        result.append(NormalClassLoaderRenderer.getAsMultiLine(loader, indent + "    "));
        return result.toString();
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.packageText.setText("a.quiet.extensive.package.name.we.seldom.see.out.there.");
        this.classText.setText("AClassNameOfAn$InnerClassThisIs");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.packageText.setText("a.small.package.");
        this.classText.setText("ANormalClass.");
        return this.root;
    }

    public static String getGeneratedClassText(ClassObject clazz) {
        String fullName = clazz.getFullName();
        if (fullName.startsWith("sun.reflect.GeneratedSerializationConstructorAccessor") || fullName.startsWith("sun.reflect.GeneratedConstructorAccessor") || fullName.startsWith("sun.reflect.GeneratedMethodAccessor")) {
            return clazz.getClassLoader().getDisplayName();
        }
        return null;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (entry instanceof NormalClass) {
            ClassObject clazz = ((NormalClass)entry).getClassObject();
            String info = NormalClassRenderer.getGeneratedClassText(clazz);
            return clazz.getFullName() + (info != null ? "\n" + info : "");
        }
        return ((NormalClassPers)entry).getFullName();
    }

    private String getClassNames(Object[] entries, String indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < i; ++j) {
                result.append(indent);
            }
            String fullName = entries[i] instanceof NormalClassPers ? ((NormalClassPers)entries[i]).getFullName() : ((NormalClass)entries[i]).getClassObject().getFullName();
            result.append(fullName);
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} class which is considered irrelevant:\n\n{1}", (String)"{0} classes which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getClassNames(entries, "")});
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} class", (String)"{0} classes", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} class which is considered irrelevant:\n\n{1}", (String)"Show the {0} classes which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getClassNames(entries, "")});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} class which is skipped:\n\n{1}", (String)"{0} classes which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getClassNames(entries, "   ")});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        return I18n._ssn((String)"Show the {0} class which is skipped:\n\n{1}", (String)"Show the {0} classes which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getClassNames(entries, "   ")});
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext context) {
        return null;
    }
}

