/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassType;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalClassTypeRenderer
extends EntryRendererBase {
    public static final String CLASS_NON_ARRAY_IMAGE_TAG = "classType.image.classNonArray";
    public static final String CLASS_ARRAY_IMAGE_TAG = "classType.image.classArray";
    public static final String ENUM_NON_ARRAY_IMAGE_TAG = "classType.image.enumNonArray";
    public static final String ENUM_ARRAY_IMAGE_TAG = "classType.image.enumArray";
    public static final String INTERNAL_CLASS_NON_ARRAY_IMAGE_TAG = "classType.image.internalClassNonArray";
    public static final String INTERNAL_CLASS_ARRAY_IMAGE_TAG = "classType.image.internalClassArray";
    public static final String PRIMITIVE_ARRAY_IMAGE_TAG = "classType.image.primitiveArray";
    public static final String INTERFACE_ARRAY_IMAGE_TAG = "classType.image.interfaceArray";
    private final RendererNode[] images;
    private final AlternateNode<?> allImages;
    private final String[] imageTags;
    private final String[] altTexts;
    private final TextNode text;

    public NormalClassTypeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} classes"), I18n._s((String)"{0} other classes"), I18n._s((String)"{0} skipped classes"));
        this.imageTags = new String[NormalClassType.ClassType.values().length];
        this.imageTags[NormalClassType.ClassType.CLASS.ordinal()] = CLASS_NON_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.CLASS_ARRAY.ordinal()] = CLASS_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.INTERFACE.ordinal()] = CLASS_NON_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.INTERFACE_ARRAY.ordinal()] = INTERFACE_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.PRIMITIVE.ordinal()] = CLASS_NON_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.PRIMITIVE_ARRAY.ordinal()] = PRIMITIVE_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.INTERNAL.ordinal()] = INTERNAL_CLASS_NON_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.INTERNAL_ARRAY.ordinal()] = INTERNAL_CLASS_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.UNDEFINED.ordinal()] = CLASS_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.ENUM.ordinal()] = ENUM_NON_ARRAY_IMAGE_TAG;
        this.imageTags[NormalClassType.ClassType.ENUM_ARRAY.ordinal()] = ENUM_ARRAY_IMAGE_TAG;
        this.altTexts = new String[NormalClassType.ClassType.values().length];
        this.altTexts[NormalClassType.ClassType.CLASS.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A non-array class");
        this.altTexts[NormalClassType.ClassType.CLASS_ARRAY.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array class");
        this.altTexts[NormalClassType.ClassType.INTERFACE.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An interface");
        this.altTexts[NormalClassType.ClassType.INTERFACE_ARRAY.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of interfaces");
        this.altTexts[NormalClassType.ClassType.PRIMITIVE.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A primitive type");
        this.altTexts[NormalClassType.ClassType.PRIMITIVE_ARRAY.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of primitive types");
        this.altTexts[NormalClassType.ClassType.INTERNAL.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An internal class");
        this.altTexts[NormalClassType.ClassType.INTERNAL_ARRAY.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of internal types");
        this.altTexts[NormalClassType.ClassType.UNDEFINED.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An undefined type");
        this.altTexts[NormalClassType.ClassType.ENUM.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An enumeration type");
        this.altTexts[NormalClassType.ClassType.ENUM_ARRAY.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of enumeration types");
        this.text = viewer.newTextNode(null);
        this.images = new RendererNode[this.imageTags.length];
        RendererNode[] rawImages = new RendererNode[this.imageTags.length];
        for (int i = 0; i < this.images.length; ++i) {
            rawImages[i] = theme.decorate(this.imageTags[i], viewer, this.text, this.altTexts[i]);
            this.images[i] = viewer.newAlignNode(0, viewer.newMultiChildNode(viewer.newSpaceNode(5), rawImages[i], viewer.newSpaceNode(5)));
        }
        this.allImages = viewer.newAlternateNode(0, rawImages);
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalClassType type = (NormalClassType)entry;
        this.text.setText("");
        return this.images[type.getType().ordinal()];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("");
        return this.images[0];
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        switch (((NormalClassType)entry).getType()) {
            case CLASS: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A non-interface, non-internal, non-array class");
            }
            case CLASS_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of a non-interface, non-internal class");
            }
            case INTERFACE: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An interface");
            }
            case INTERFACE_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of interfaces");
            }
            case PRIMITIVE: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A primitive type");
            }
            case PRIMITIVE_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of primitive type");
            }
            case INTERNAL: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An internal non-array class");
            }
            case INTERNAL_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of internal classes");
            }
            case UNDEFINED: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An unknown class type");
            }
            case ENUM: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An enumration type");
            }
            case ENUM_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"An array of enumeration types");
            }
        }
        return null;
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        NormalClassType type = (NormalClassType)entry;
        this.allImages.setSelected(type.getType().ordinal());
        return this.viewer.newMultiChildNode(this.allImages, this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count}))));
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        switch (((NormalClassType)entry).getType()) {
            case CLASS: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} non-interface, non-internal, non-array classes", (Object[])new Object[]{count});
            }
            case CLASS_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} array of a non-interface, non-internal classes", (Object[])new Object[]{count});
            }
            case INTERFACE: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} interfaces", (Object[])new Object[]{count});
            }
            case INTERFACE_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} arrays of interfaces", (Object[])new Object[]{count});
            }
            case PRIMITIVE: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} primitive types", (Object[])new Object[]{count});
            }
            case PRIMITIVE_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} arrays of primitive types", (Object[])new Object[]{count});
            }
            case INTERNAL: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} internal non-array classes", (Object[])new Object[]{count});
            }
            case INTERNAL_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} arrays of internal classes", (Object[])new Object[]{count});
            }
            case UNDEFINED: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} unknown class types", (Object[])new Object[]{count});
            }
            case ENUM: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} enumration types", (Object[])new Object[]{count});
            }
            case ENUM_ARRAY: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"{0} arrays of enumeration types", (Object[])new Object[]{count});
            }
        }
        return null;
    }
}

