/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalFileIdRenderer
extends EntryRendererBase {
    public static final String TAG = "file.index";
    private final TextNode index;
    private final RendererNode root;

    public NormalFileIdRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} file accesses"), I18n._s((String)"{0} other file accesses"), I18n._s((String)"{0} skipped file accesses"));
        this.index = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.index);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("1000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("100000");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.index.setText("" + ((NormalFileId)entry).getIndex());
        return this.root;
    }

    public String getToolTip(Object entry) {
        NormalFileId fileId = (NormalFileId)entry;
        return this.formatText(I18n._s((String)"File index {0}"), fileId.getIndex());
    }
}

