/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalFileNameRenderer
extends EntryRendererBase {
    public static final String IMAGE_TAG = "classObject.image";
    public static final String PATH_TAG = "fileName.path";
    public static final String NAME_TAG = "fileName.name";
    private final TextNode pathText;
    private final TextNode nameText;
    private final RendererNode root;

    public NormalFileNameRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} files"), I18n._s((String)"{0} other files"), I18n._s((String)"{0} skipped files"));
        this.pathText = viewer.newTextNode(null);
        this.nameText = viewer.newTextNode(null);
        this.root = theme.decorate(IMAGE_TAG, viewer, viewer.newOrderedMultiChildNode(new int[]{1, 0}, new RendererNode[]{viewer.newAlignNode(1, theme.decorate(PATH_TAG, viewer, this.pathText)), viewer.newAlignNode(1, theme.decorate(NAME_TAG, viewer, this.nameText))}));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.pathText.setText("d:\\very\\very\\very\\very\\very\\very\\very\\very\\very\\path\\");
        this.nameText.setText("filenamefilename.txt");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.pathText.setText("d:\\short\\short\\short\\short\\short\\path\\");
        this.nameText.setText("filename.txt");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        String fileName;
        String pathName;
        NormalFileName fileNameEntry = (NormalFileName)entry;
        if (fileNameEntry.getName().isEmpty()) {
            pathName = "";
            fileName = "<unknown file>";
        } else {
            pathName = fileNameEntry.getPathName();
            fileName = fileNameEntry.getFileName();
        }
        this.pathText.setText(pathName);
        this.nameText.setText(fileName);
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalFileName thread = (NormalFileName)entry;
        if (thread.getName() == null) {
            return I18n._s((String)"Unknown file");
        }
        return I18n._s((String)"File '{0}'", (Object[])new Object[]{thread.getDisplayFileName()});
    }
}

