/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntity;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntityPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalFilterEntityRenderer
extends MultiEntryRendererBase {
    public static final String METHOD_FILTER_TAG = "entity.filter";
    private final TextNode text;
    private final RendererNode methodRoot;

    public NormalFilterEntityRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} filters"), I18n._s((String)"{0} other filters"), I18n._s((String)"{0} skipped filters"));
        this.text = viewer.newTextNode(null);
        this.methodRoot = theme.decorate(METHOD_FILTER_TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("quite a long method filter name we hopefully never see");
        return this.methodRoot;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("a normal method filter name");
        return this.methodRoot;
    }

    private String getName(Object o) {
        String filterName = null;
        if (o instanceof NormalFilterEntityPers) {
            filterName = ((NormalFilterEntityPers)o).getFilterName();
        } else {
            NormalFilterEntity entity = (NormalFilterEntity)o;
            MethodFilter filter = entity.getEntity().getFilter();
            if (filter != null) {
                filterName = filter.getName();
            }
        }
        if (filterName == null) {
            return I18n._s((String)"<none>");
        }
        return filterName;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.text.setText(this.getName(entry));
        return this.methodRoot;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        String filterName = null;
        if (entry instanceof NormalFilterEntityPers) {
            filterName = ((NormalFilterEntityPers)entry).getFilterName();
        } else {
            NormalFilterEntity entity = (NormalFilterEntity)entry;
            MethodFilter filter = entity.getEntity().getFilter();
            if (filter != null) {
                filterName = filter.getName();
            }
        }
        if (filterName == null) {
            return I18n._s((String)"The part matching no filters");
        }
        return filterName;
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter which is considered irrelevant:\n\n{1}", (String)"{0} filters which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "", context)});
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter", (String)"{0} filters", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} filter which is considered irrelevant.", (String)"Show the {0} filters which are considered irrelevant.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter which is skipped:\n\n{1}", (String)"{0} filters which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "   ", context)});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} filter which is skipped.", (String)"Show the {0} filters which are skipped.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext context) {
        return this.getName(entry);
    }
}

