/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntryPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalFilterEntryRenderer
extends MultiEntryRendererBase {
    public static final String DIRECTORY_TAG = "filter.directoryEntry";
    public static final String CLASS_FILTER_TAG = "filter.classEntry";
    public static final String METHOD_FILTER_TAG = "filter.methodEntry";
    private final TextNode text;
    private final RendererNode directoryRoot;
    private final RendererNode classRoot;
    private final RendererNode methodRoot;

    public NormalFilterEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} filters"), I18n._s((String)"{0} other filters"), I18n._s((String)"{0} skipped filters"));
        this.text = viewer.newTextNode(null);
        this.directoryRoot = theme.decorate(DIRECTORY_TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text));
        this.classRoot = theme.decorate(CLASS_FILTER_TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text));
        this.methodRoot = theme.decorate(METHOD_FILTER_TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("quite a long class filter name we hopefully never see");
        return this.classRoot;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("a normal class filter name");
        return this.classRoot;
    }

    private String getFilterName(Object o) {
        if (o instanceof NormalFilterEntryPers) {
            NormalFilterEntryPers entry = (NormalFilterEntryPers)o;
            if (entry.getEntryName() == null) {
                return I18n._s((String)"<none>");
            }
            return entry.getEntryName();
        }
        NormalFilterEntry entry = (NormalFilterEntry)o;
        if (entry.getEntry() == null) {
            return I18n._s((String)"<none>");
        }
        return entry.getEntry().getName();
    }

    @Override
    public RendererNode getRenderer(ProviderEntry o, EntryContext context, ColumnContext columnContext) {
        if (o instanceof NormalFilterEntryPers) {
            NormalFilterEntryPers entry = (NormalFilterEntryPers)o;
            if (entry.getEntryName() == null) {
                this.text.setText(I18n._s((String)"<none>"));
                return this.text;
            }
            this.text.setText(entry.getEntryName());
            if (entry.isDirectory()) {
                return this.directoryRoot;
            }
            if (entry.isClassFilter()) {
                return this.classRoot;
            }
            return this.methodRoot;
        }
        NormalFilterEntry entry = (NormalFilterEntry)o;
        if (entry.getEntry() == null) {
            this.text.setText(I18n._s((String)"<none>"));
            return this.text;
        }
        this.text.setText(entry.getEntry().getName());
        if (entry.getEntry().isDirectory()) {
            return this.directoryRoot;
        }
        if (entry.getEntry().isClassFilter()) {
            return this.classRoot;
        }
        return this.methodRoot;
    }

    @Override
    public String getToolTip(ProviderEntry o, EntryContext context, ColumnContext columnContext) {
        if (o instanceof NormalFilterEntryPers) {
            NormalFilterEntryPers entry = (NormalFilterEntryPers)o;
            if (entry.getEntryName() == null) {
                return I18n._s((String)"<none>");
            }
            return entry.getEntryName();
        }
        NormalFilterEntry entry = (NormalFilterEntry)o;
        if (entry.getEntry() == null) {
            return I18n._s((String)"<none>");
        }
        return entry.getEntry().getName();
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter which is considered irrelevant:\n\n{1}", (String)"{0} filters which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "", context)});
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter", (String)"{0} filters", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} filter which is considered irrelevant.", (String)"Show the {0} filters which are considered irrelevant.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} filter which is skipped:\n\n{1}", (String)"{0} filters which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "   ", context)});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} filter which is skipped.", (String)"Show the {0} filters which are skipped.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext context) {
        return this.getFilterName(entry);
    }
}

