/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalGcIdRenderer
extends EntryRendererBase {
    public static final String TAG = "gc.index";
    private final TextNode index;
    private final RendererNode root;

    public NormalGcIdRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} GCs"), I18n._s((String)"{0} other GCs"), I18n._s((String)"{0} skipped GCs"));
        this.index = viewer.newTextNode(null);
        this.root = viewer.newAlignNode(1, theme.decorate(TAG, viewer, this.index));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("1000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("100000");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.index.setText("" + ((NormalGcId)entry).getId());
        return this.root;
    }

    public String getToolTip(Object entry) {
        NormalGcId gcId = (NormalGcId)entry;
        return this.formatText(I18n._s((String)"GC number {0}"), gcId.getId());
    }
}

