/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddress;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalNetworkAddressRenderer
extends EntryRendererBase {
    private final TextNode root;
    private final String unknownRemoteAddress = I18n._s((String)"<unconnected>");

    public NormalNetworkAddressRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} addresses"), I18n._s((String)"{0} addresses"), I18n._s((String)"{0} addresses"));
        this.root = viewer.newTextNode(null);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText("0000:0000:0000:0000:0000:0000:0000:0000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText("::");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalNetworkAddress address = (NormalNetworkAddress)entry;
        if (IpAddressUtil.isUnknown((IpAddress)address.getAddress()) && !address.isLocal()) {
            this.root.setText(this.unknownRemoteAddress);
        } else {
            this.root.setText(address.getAddress().getAddress());
        }
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalNetworkAddress address = (NormalNetworkAddress)entry;
        if (IpAddressUtil.isUnknown((IpAddress)address.getAddress()) && !address.isLocal()) {
            return this.unknownRemoteAddress;
        }
        return address.getAddress().getAddress();
    }
}

