/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionType;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalNetworkConnectionTypeRenderer
extends EntryRendererBase {
    private static final String streamText = I18n._s((String)"TCP/IP");
    private static final String datagramText = I18n._s((String)"UDP/IP");
    private final TextNode root;

    public NormalNetworkConnectionTypeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.root = viewer.newTextNode(null);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText(streamText.length() > datagramText.length() ? streamText : datagramText);
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.root.setText(((NormalNetworkConnectionType)entry).isStreamSocket() ? streamText : datagramText);
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((NormalNetworkConnectionType)entry).isStreamSocket() ? I18n._s((String)"Network connection using a stream socket with TCP/IP as protocol") : I18n._s((String)"Network connection using a datagram socket with UDP/IP as protocol");
    }
}

