/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointType;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalNetworkEndpointTypeRenderer
extends EntryRendererBase {
    private static final String serverText = I18n._s((String)"server");
    private static final String clientText = I18n._s((String)"client");
    private static final String unconnectedText = I18n._s((String)"unconnected");
    private final TextNode root;

    public NormalNetworkEndpointTypeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.root = viewer.newTextNode(null);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText(serverText.length() > clientText.length() ? serverText : clientText);
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (((NormalNetworkEndpointType)entry).getSideType() == NetworkConnectionSideType.SERVER) {
            this.root.setText(serverText);
        } else if (((NormalNetworkEndpointType)entry).getSideType() == NetworkConnectionSideType.CLIENT) {
            this.root.setText(clientText);
        } else {
            assert (((NormalNetworkEndpointType)entry).getSideType() == NetworkConnectionSideType.UNCONNECTED);
            this.root.setText(unconnectedText);
        }
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((NormalNetworkEndpointType)entry).getSideType() == NetworkConnectionSideType.SERVER ? I18n._s((String)"Server side of the network connection, i.e. the side on which accept(...) was called") : (((NormalNetworkEndpointType)entry).getSideType() == NetworkConnectionSideType.CLIENT ? I18n._s((String)"Client side of the network connection, i.e. the side on which connect(...) was called") : I18n._s((String)"The network connection was not established, yet"));
    }
}

