/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalPackageRenderer
extends MultiEntryRendererBase {
    public static final String TAG = "package";
    private final TextNode text;
    private final RendererNode root;

    public NormalPackageRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} packages"), I18n._s((String)"{0} other packages"), I18n._s((String)"{0} skipped packages"));
        this.text = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("a.very.very.long.package.name.we.will.probably.never.see.in.the.real.world.out.there");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("a.normal.package.name.you.are.likely.to.see");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.text.setText(this.getEntryName(entry, context));
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.getEntryName(entry, context);
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} package which is considered irrelevant:\n\n{1}", (String)"{0} packages which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "", context)});
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} package", (String)"{0} packages", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} package which is considered irrelevant.", (String)"Show the {0} packages which are considered irrelevant.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} package which is skipped:\n\n{1}", (String)"{0} packages which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "   ", context)});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} package which is skipped.", (String)"Show the {0} packages which are skipped.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext context) {
        return NormalPackage.getDisplayName(((NormalPackage)entry).getPackage());
    }
}

