/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalParameterSpecRenderer
extends EntryRendererBase {
    public static final String TAG = "paramSpec";
    private final TextNode paramSpec;
    private final RendererNode root;

    public NormalParameterSpecRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} specifications"), I18n._s((String)"{0} other specifications"), I18n._s((String)"{0} skipped specifications"));
        this.paramSpec = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.paramSpec);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.paramSpec.setText("A very long and synthetic specification");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.paramSpec.setText("ThisIsATypicalSpecification");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.paramSpec.setText(((NormalParameterSpec)entry).getDisplaySpecification());
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        String filter = ((NormalParameterSpec)entry).getSpecification();
        if (filter.length() == 0) {
            return I18n._s((String)"No specification");
        }
        return I18n._s((String)"Parameter specification '{0}'", (Object[])new Object[]{((NormalParameterSpec)entry).getDisplaySpecification()});
    }
}

