/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalMethodAndReceiverRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodAndReceiver;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValuePers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalParameterValueRenderer
extends EntryRendererBase {
    private static final String TAG = "paramValue";
    private static final String ERROR_TAG = "paramValue.error";
    private final TextNode value;
    private final RendererNode root;
    private final RendererNode errorRoot;
    private final NormalClassRenderer classRenderer;
    private final NormalMethodAndReceiverRenderer methodRenderer;

    public NormalParameterValueRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} values"), I18n._s((String)"{0} other values"), I18n._s((String)"{0} skipped values"));
        this.value = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.value);
        this.errorRoot = theme.decorate(ERROR_TAG, viewer, this.value);
        this.classRenderer = new NormalClassRenderer(viewer, theme);
        this.methodRenderer = new NormalMethodAndReceiverRenderer(viewer, theme);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.value.setText("A very long and synthetic valuevaluevaluevalue");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.value.setText("ThisIsATypicalValueValueValue");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (entry instanceof NormalParameterValuePers) {
            NormalParameterValuePers paramEntry = (NormalParameterValuePers)entry;
            if (paramEntry.getValue() instanceof NormalClassPers) {
                return this.classRenderer.getRenderer((NormalClassPers)paramEntry.getValue(), context, columnContext);
            }
            if (paramEntry.getValue() instanceof NormalMethodPers) {
                return this.methodRenderer.getRenderer((NormalMethodPers)paramEntry.getValue(), context, columnContext);
            }
            Parameter param = (Parameter)paramEntry.getValue();
            this.value.setText(new NormalParameterValue(param).getDisplayValue());
            if (param.isErrorType()) {
                return this.errorRoot;
            }
            return this.root;
        }
        NormalParameterValue paramEntry = (NormalParameterValue)entry;
        if (paramEntry.getValue() instanceof ClassParameter) {
            return this.classRenderer.getRenderer(new NormalClass(((ClassParameter)paramEntry.getValue()).getValue()), context, columnContext);
        }
        if (paramEntry.getValue() instanceof MethodParameter) {
            MethodParameter methodParam = (MethodParameter)paramEntry.getValue();
            return this.methodRenderer.getRenderer(new NormalMethodAndReceiver(methodParam.getMethod(), methodParam.getReceiverClass()), context, columnContext);
        }
        this.value.setText(paramEntry.getDisplayValue());
        if (paramEntry.getValue().isErrorType()) {
            return this.errorRoot;
        }
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        String valueStr;
        NormalParameterValue paramEntry = (NormalParameterValue)entry;
        Parameter param = paramEntry.getValue();
        if (param instanceof ClassParameter) {
            return this.classRenderer.getToolTip(new NormalClass(((ClassParameter)paramEntry.getValue()).getValue()), context, columnContext);
        }
        if (param instanceof MethodParameter) {
            MethodParameter methodParam = (MethodParameter)paramEntry.getValue();
            return this.methodRenderer.getToolTip(new NormalMethodAndReceiver(methodParam.getMethod(), methodParam.getReceiverClass()), context, columnContext);
        }
        if (param.isErrorType()) {
            switch (param.getType()) {
                case CLASS_CAST_EXCEPTION: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"A class cast exception occured during a cast specified by the modifiers");
                }
                case ENABLE_FAILED: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Enabling the trace failed for at least one method");
                }
                case EXCEPTION_DURING_CALL: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"An exception occured during a call from one of the modifiers");
                }
                case INDEX_OUT_OF_BOUNDS: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"An array index was out of bounds of a [] modifier");
                }
                case NULL: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"The parameter to trace was null");
                }
                case NULL_INVOCATION_DURING_CALL: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Tried to apply a modfier for a null value");
                }
                case UNKNOWN: {
                    return I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"The method was already active when the trace was enabled, so the parameter value could not be determined");
                }
            }
        }
        if ((valueStr = paramEntry.getDisplayValue()).length() == 0) {
            return I18n._s((String)"No value");
        }
        return I18n._s((String)"Parameter value '{0}'", (Object[])new Object[]{((NormalParameterValue)entry).getDisplayValue()});
    }
}

