/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalReentrantLockIdRenderer
extends EntryRendererBase {
    public static final String TAG = "reentrant.lock.id";
    private final TextNode id;
    private final RendererNode root;

    public NormalReentrantLockIdRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} reentrant locks"), I18n._s((String)"{0} other reentrant locks"), I18n._s((String)"{0} skipped reentrant locks"));
        this.id = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.id);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.id.setText("1000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.id.setText("100000");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.id.setText("" + ((NormalReentrantLockId)entry).getId());
        return this.root;
    }

    public String getToolTip(Object entry) {
        NormalReentrantLockId monitor2 = (NormalReentrantLockId)entry;
        return this.formatText(I18n._s((String)"Reentrant lock id {0}"), monitor2.getId());
    }
}

