/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalSocketIdRenderer
extends EntryRendererBase {
    public static final String TAG = "socket.index";
    private final TextNode index;
    private final RendererNode root;

    public NormalSocketIdRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} socket accesses"), I18n._s((String)"{0} other socket accesses"), I18n._s((String)"{0} skipped socket accesses"));
        this.index = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.index);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("1000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.index.setText("100000");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.index.setText("" + ((NormalSocketId)entry).getIndex());
        return this.root;
    }

    public String getToolTip(Object entry) {
        NormalSocketId socketId = (NormalSocketId)entry;
        return this.formatText(I18n._s((String)"Socket index {0}"), socketId.getIndex());
    }
}

