/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalThreadAnnotationRenderer
extends EntryRendererBase {
    public static final String TAG = "annotation";
    private final TextNode value;
    private final RendererNode root;

    public NormalThreadAnnotationRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.value = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.value);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.value.setText("A very long and synthetic thread annotation value");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.value.setText("ThisIsATypicalAnnotation");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.value.setText(((NormalThreadAnnotation)entry).getDisplayAnnotationValue());
        return this.root;
    }

    @Override
    public RendererNode getRendererForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        NormalThreadAnnotation annotation = (NormalThreadAnnotation)entries[0];
        this.value.setText(annotation.getContext().getOtherChildrenText(entries.length));
        return this.value;
    }

    @Override
    public RendererNode getRendererForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        NormalThreadAnnotation annotation = (NormalThreadAnnotation)entries[0];
        this.value.setText(annotation.getContext().getSkippedChildrenText(entries.length));
        return this.value;
    }

    @Override
    public RendererNode getRendererForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        NormalThreadAnnotation annotation = (NormalThreadAnnotation)entries[0];
        this.value.setText(annotation.getContext().getCombinedItemsText(entries.length));
        return this.value;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalThreadAnnotation annotation = (NormalThreadAnnotation)entry;
        return annotation.getContext().getToolTip(annotation.getValue());
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        NormalThreadAnnotation annotation = (NormalThreadAnnotation)entries[0];
        return annotation.getContext().getToolTipForCombinedItems(entries.length);
    }
}

