/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadDumpAlertType;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class NormalThreadDumpAlertTypeRenderer
extends EntryRendererBase {
    private static final String THREAD_ALERT_NONE_TAG = "threadDumAlertType.image.none";
    private static final String THREAD_ALERT_DEADLOCK_TAG = "threadDumAlertType.image.deadlock";
    private final String[] imageTags = new String[NormalThreadDumpAlertType.AlertType.values().length];
    private final RendererNode[] images;
    private final String[] altTexts;
    private final TextNode text;

    public NormalThreadDumpAlertTypeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.imageTags[NormalThreadDumpAlertType.AlertType.DEADLOCK.ordinal()] = THREAD_ALERT_DEADLOCK_TAG;
        this.imageTags[NormalThreadDumpAlertType.AlertType.NONE.ordinal()] = THREAD_ALERT_NONE_TAG;
        this.altTexts = new String[NormalThreadDumpAlertType.AlertType.values().length];
        this.altTexts[NormalThreadDumpAlertType.AlertType.DEADLOCK.ordinal()] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Deadlock");
        this.altTexts[NormalThreadDumpAlertType.AlertType.NONE.ordinal()] = "";
        this.text = viewer.newTextNode(null);
        this.images = new RendererNode[this.imageTags.length];
        RendererNode[] rawImages = new RendererNode[this.imageTags.length];
        for (int i = 0; i < this.images.length; ++i) {
            rawImages[i] = this.imageTags[i] == THREAD_ALERT_NONE_TAG ? viewer.newSpaceNode(1) : theme.decorate(this.imageTags[i], viewer, this.text, this.altTexts[i]);
            this.images[i] = viewer.newAlignNode(0, viewer.newMultiChildNode(viewer.newSpaceNode(5), rawImages[i], viewer.newSpaceNode(5)));
        }
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalThreadDumpAlertType type = (NormalThreadDumpAlertType)entry;
        this.text.setText("");
        return this.images[type.getType().ordinal()];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("");
        return this.text;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        switch (((NormalThreadDumpAlertType)entry).getType()) {
            case NONE: {
                return null;
            }
            case DEADLOCK: {
                return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"deadlock detected");
            }
        }
        return null;
    }
}

