/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalThreadIdRenderer
extends EntryRendererBase {
    public static final String TAG = "thread.id";
    private final TextNode id;
    private final RendererNode root;

    public NormalThreadIdRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} threads"), I18n._s((String)"{0} other threads"), I18n._s((String)"{0} skipped threads"));
        this.id = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, viewer.newAlignNode(1, this.id));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.id.setText("1000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.id.setText("100000");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        long threadId = ((NormalThreadId)entry).getId();
        this.id.setText(threadId <= 0L ? "" : "" + threadId);
        return this.root;
    }

    public String getToolTip(Object entry) {
        NormalThreadId thread = (NormalThreadId)entry;
        return this.formatText(I18n._s((String)"Thread id {0}"), thread.getId());
    }
}

