/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalThreadNameRenderer
extends EntryRendererBase {
    public static final String TAG = "thread.name";
    public static final String MODIFICATION_LABEL_TAG = "thread.label";
    private final TextNode name;
    private final TextNode modificationLabelText;
    private final RendererNode root;
    private final RendererNode rootBold;

    public NormalThreadNameRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} threads"), I18n._s((String)"{0} other threads"), I18n._s((String)"{0} skipped threads"));
        this.name = viewer.newTextNode(null);
        this.modificationLabelText = viewer.newTextNode(null);
        this.root = viewer.newMultiChildNode(theme.decorate(TAG, viewer, this.name), theme.decorate(MODIFICATION_LABEL_TAG, viewer, this.modificationLabelText));
        this.rootBold = viewer.newChangeBoldNode(true, this.root);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.name.setText("A very very very very vervy long thread name");
        this.modificationLabelText.setText("#1234_Old");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.name.setText("A quite normal Thread name to use");
        this.modificationLabelText.setText("");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalThreadName tname = (NormalThreadName)entry;
        this.name.setText(tname.getDisplayThreadName());
        if (tname.getModificationLabel() != null) {
            this.modificationLabelText.setText(tname.getModificationLabel());
        } else {
            this.modificationLabelText.setText("");
        }
        return tname.isBold() ? this.rootBold : this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalThreadName thread = (NormalThreadName)entry;
        StringBuilder result = new StringBuilder();
        if (thread.getName() == null) {
            result.append(I18n._s((String)"Unknown thread"));
        } else {
            result.append(I18n._s((String)"Thread '{0}'", (Object[])new Object[]{thread.getDisplayThreadName()}));
        }
        String label = thread.getModificationLabel();
        if (label != null) {
            result.append("\n");
            result.append(I18n._s((String)"This is one of multiple threads with the same name."));
        }
        return result.toString();
    }
}

