/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.AmountByAgeRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.AmountByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsByAge;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.BarsChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public class NrOfObjectsByAgeRenderer
extends AmountByAgeRendererBase {
    public static final String NUMBER_TAG = "nrOfObjects.number";
    public static final String PERCENTAGE_TAG = "nrOfObjects.percentage";
    public static final String PERCENTAGE_BAR_TAG = "nrOfObjects.percentage-bar";
    private final BarsChartNode chartNode;
    private final RendererNode rootNode;

    public NrOfObjectsByAgeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.chartNode = viewer.newBarsChartNode();
        this.rootNode = theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.chartNode);
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.chartNode.clear();
        AmountByAge distribution = (AmountByAge)entry;
        long[] values = distribution.getDistribution();
        for (int i = 0; i < values.length; ++i) {
            this.chartNode.addValue(values[i]);
        }
        this.chartNode.setYAxisRange(0L, distribution.getMax());
        this.chartNode.setXAxisRange(0L, values.length);
        return this.rootNode;
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.chartNode.clear();
        for (int i = 0; i < 16; ++i) {
            this.chartNode.addValue(10L);
        }
        this.chartNode.setYAxisRange(0L, 10L);
        return this.rootNode;
    }

    @Override
    protected AmountByAge getCombinedDistribution(ProviderEntry[] entries) {
        return new NrOfObjectsByAge(AmountByAge.getSum(entries));
    }
}

