/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsMax;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class NrOfObjectsMaxRenderer
extends EntryRendererBase {
    public static final String VALUE_TEXT_TAG = "nrOfObjects.number";
    public static final String MAX_TEXT_TAG = "nrOfObjects.number";
    public static final String PERCENTAGE_BAR_TAG = "nrOfObjects.percentage-bar";
    private TextNode valueTextNode;
    private TextNode maxTextNode;
    private PercentageBarNode percentageNode;
    private RendererNode root;

    public NrOfObjectsMaxRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.valueTextNode = viewer.newTextNode(null);
        this.maxTextNode = viewer.newTextNode(null);
        this.percentageNode = viewer.newPercentageBarNode();
        this.root = viewer.newAlignNode(1, viewer.newOrderedMultiChildNode(new int[]{0, 1, 2, 3, 4, 5, 6}, new RendererNode[]{theme.decorate("nrOfObjects.number", viewer, this.valueTextNode), viewer.newSpaceNode(5), viewer.newChangeBoldNode(false, viewer.newTextNode(I18n._s((String)"of"))), viewer.newSpaceNode(5), theme.decorate("nrOfObjects.number", viewer, this.maxTextNode), viewer.newSpaceNode(10), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNode)}));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NrOfObjectsMax usage = (NrOfObjectsMax)entry;
        return this.getRenderer(usage.getValue(), usage.getMaxValue());
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.getRenderer(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NrOfObjectsMax usage = (NrOfObjectsMax)entry;
        return this.getToolTip(usage.getValue(), usage.getMaxValue());
    }

    private RendererNode getRenderer(long value, long max) {
        this.valueTextNode.setText(Long.toString(value));
        this.maxTextNode.setText(Long.toString(max));
        double percentage = (double)value / (double)max;
        this.percentageNode.setPercentage(percentage, 0.0, 0.0);
        return this.root;
    }

    private String getToolTip(long value, long max) {
        String percentageStr = DataFormatter.getPercentage((double)((double)value / (double)max));
        return String.format("%d of %d (%s)", value, max, percentageStr);
    }
}

