/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ReportQuality;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.Progress;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class ProgressRenderer
extends EntryRendererBase {
    public static final String PERCENTAGE_BAR_TAG = "progress.percentage-bar";
    private static double qualityClassWidth = 1.0 / (double)(ReportQuality.values().length - 2);
    private PercentageBarNode percentageNode;
    private final TextNode percentageTextNode;
    private RendererNode[] roots;

    public ProgressRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.percentageNode = viewer.newPercentageBarNode();
        this.percentageNode = viewer.newPercentageBarNode();
        this.percentageTextNode = viewer.newTextNode(null);
        int numQualityClasses = ReportQuality.values().length;
        this.roots = new RendererNode[numQualityClasses];
        int i = 0;
        for (ReportQuality quality : ReportQuality.values()) {
            this.roots[i] = viewer.newMultiChildNode(this.percentageTextNode, viewer.newSpaceNode(10), theme.decorate("progress.percentage-bar-" + quality.getTag(), viewer, this.percentageNode));
            ++i;
        }
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        Progress progress = (Progress)entry;
        return this.getRenderer(progress.getProgress());
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.getRenderer(1.0);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        Progress usage = (Progress)entry;
        return this.getToolTip(usage.getProgress());
    }

    private RendererNode getRenderer(double progress) {
        assert (0.0 <= progress && progress <= 1.0);
        int qualityClass = (int)(progress / qualityClassWidth);
        if (progress > 0.0) {
            ++qualityClass;
        }
        this.percentageNode.setPercentage(progress, 0.0, 0.0);
        this.percentageTextNode.setText(ReportQuality.values()[qualityClass].getDisplayText());
        return this.roots[qualityClass];
    }

    private String getToolTip(double progress) {
        return DataFormatter.getPercentage((double)progress, (int)0);
    }
}

