/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.typed.HighlightSpec;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.ObjectPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;

public final class RendererThemeImpl
implements RendererTheme {
    private final RendererThemeSpec spec;
    private int additionalAscend;
    private int additionalDescend;
    private int additionalLeading;
    private HighlightSpec highlightSpec;
    private final HashMap<String, URI> prependImages;
    private final HashMap<String, URI> appendImages;
    private final HashMap<String, int[]> colors;
    private final HashMap<String, Integer> fontSizeChanges;
    private final HashMap<String, Boolean> boldnessChanges;
    private final HashMap<String, Boolean> italicsChanges;
    private final HashMap<String, ObjectPair<Pattern, String>> variables;

    public RendererThemeImpl(OSThemeSpec osTheme) {
        this.spec = new RendererThemeSpec(osTheme);
        this.prependImages = new HashMap();
        this.appendImages = new HashMap();
        this.colors = new HashMap();
        this.fontSizeChanges = new HashMap();
        this.boldnessChanges = new HashMap();
        this.italicsChanges = new HashMap();
        this.variables = new HashMap();
        this.highlightSpec = new HighlightSpec(16776905, 0, 0xFFFF00);
    }

    public RendererThemeImpl(RendererThemeSpec spec) throws IOException {
        String line;
        this.spec = spec.copy();
        StringBuilder theme = new StringBuilder();
        this.addThemeFile(theme, spec.getName());
        BufferedReader reader = new BufferedReader(new StringReader(theme.toString()));
        this.prependImages = new HashMap();
        this.appendImages = new HashMap();
        this.colors = new HashMap();
        this.fontSizeChanges = new HashMap();
        this.boldnessChanges = new HashMap();
        this.italicsChanges = new HashMap();
        this.variables = new HashMap();
        int highlightBackground = 0;
        int highlightForeground = 0;
        int highlightLine = 0;
        Pattern filePattern = Pattern.compile(":");
        Pattern commentPattern = Pattern.compile("[#]");
        Pattern splitTagPattern = Pattern.compile(":");
        Pattern splitModifierPattern = Pattern.compile("\\s+");
        Pattern assignPattern = Pattern.compile(":=");
        while ((line = reader.readLine()) != null) {
            String[] arguments;
            String[] token;
            String[] fileParts = filePattern.split(line, 3);
            String fileName = fileParts[0];
            String lineNr = fileParts[1];
            String payload = fileParts[2];
            String[] parts = commentPattern.split(payload.trim());
            if (parts.length == 0 || parts[0].trim().length() == 0) continue;
            String[] variableParts = assignPattern.split(parts[0].trim(), 2);
            if (variableParts.length == 2) {
                String variable = variableParts[0].trim();
                String string = variableParts[1].trim();
                Pattern pattern = Pattern.compile(Pattern.quote("${" + (String)variable + "}"));
                this.variables.put(variable, (ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)string));
                continue;
            }
            if (parts[0].contains("$")) {
                for (ObjectPair objectPair : this.variables.values()) {
                    parts[0] = ((Pattern)objectPair.getFirst()).matcher(parts[0]).replaceAll((String)objectPair.getSecond());
                }
            }
            if ((token = splitTagPattern.split(parts[0].trim())).length < 2) continue;
            String string = token[0];
            token[1] = token[1].trim();
            if (token[1].length() == 0) continue;
            for (String arg : arguments = splitModifierPattern.split(token[1])) {
                if ("ascent.additional".equals(string)) {
                    this.additionalAscend = Integer.parseInt(arg);
                    continue;
                }
                if ("descent.additional".equals(string)) {
                    this.additionalDescend = Integer.parseInt(arg);
                    continue;
                }
                if ("leading.additional".equals(string)) {
                    this.additionalLeading = Integer.parseInt(arg);
                    continue;
                }
                if ("highlight.background".equals(string)) {
                    highlightBackground = Integer.valueOf(arg, 16);
                    continue;
                }
                if ("highlight.foreground".equals(string)) {
                    highlightForeground = Integer.valueOf(arg, 16);
                    continue;
                }
                if ("highlight.line".equals(string)) {
                    highlightLine = Integer.valueOf(arg, 16);
                    continue;
                }
                if (arg.startsWith("<") || arg.startsWith(">")) {
                    String resource = arg.substring(1, arg.length());
                    URI uri = ImageRepository.getImageURI(resource);
                    if (arg.startsWith("<")) {
                        this.prependImages.put(string, uri);
                        continue;
                    }
                    this.appendImages.put(string, uri);
                    continue;
                }
                if (arg.startsWith("c=")) {
                    if ("c=defaul".equals(arg)) {
                        this.colors.put(string, new int[]{-1});
                        continue;
                    }
                    if (arg.length() != 8) {
                        Trace.warn((String)"A color must be of the form 'c=rrggbb' and not '%s' in line %s of theme %s", (Object[])new Object[]{arg, lineNr, fileName});
                        continue;
                    }
                    int rgb = Integer.valueOf(arg.substring(2), 16);
                    this.colors.put(string, new int[]{rgb, rgb, rgb, rgb, rgb, rgb, rgb});
                    continue;
                }
                if (arg.startsWith("c1=") || arg.startsWith("c2=") || arg.startsWith("c3=") || arg.startsWith("c4=") || arg.startsWith("c5=") || arg.startsWith("c6=") || arg.startsWith("c7=")) {
                    int index = Integer.parseInt(arg.substring(1, 2)) - 1;
                    int[] c = this.colors.get(string);
                    if (c == null) {
                        c = new int[]{-1, -1, -1, -1, -1, -1, -1};
                    }
                    if ("default".equals(arg.substring(3))) {
                        c[index] = -1;
                        continue;
                    }
                    if (arg.length() == 5) {
                        int refIndex = Integer.valueOf(arg.substring(4, 5)) - 1;
                        c[index] = c[refIndex];
                        continue;
                    }
                    if (arg.length() != 9) {
                        Trace.warn((String)"A color must be of the form 'c?=rrggbb' and not '%s' in line %s of theme %s", (Object[])new Object[]{arg, lineNr, fileName});
                        continue;
                    }
                    c[index] = Integer.valueOf(arg.substring(3, 9), 16);
                    this.colors.put(string, c);
                    continue;
                }
                if ("+b".equalsIgnoreCase(arg)) {
                    this.boldnessChanges.put(string, true);
                    continue;
                }
                if ("-b".equalsIgnoreCase(arg)) {
                    this.boldnessChanges.put(string, false);
                    continue;
                }
                if ("+i".equalsIgnoreCase(arg)) {
                    this.italicsChanges.put(string, true);
                    continue;
                }
                if ("-i".equalsIgnoreCase(arg)) {
                    this.italicsChanges.put(string, false);
                    continue;
                }
                if (arg.startsWith("+") || arg.startsWith("-")) {
                    this.fontSizeChanges.put(string, Integer.parseInt(arg));
                    continue;
                }
                Trace.warn((String)"Unknown modifier '%s' in line %s of theme %s", (Object[])new Object[]{arg, lineNr, fileName});
            }
        }
        this.highlightSpec = new HighlightSpec(highlightBackground, highlightForeground, highlightLine);
    }

    private void addThemeFile(StringBuilder result, String theme) throws IOException {
        String line;
        URL file = RendererThemeImpl.getThemeURL(theme);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(file.openStream()));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("include")) {
                this.addThemeFile(result, line.split(" ")[1].trim());
                continue;
            }
            result.append(theme + ":" + reader.getLineNumber() + ":" + line + "\n");
        }
        OSThemeSpec osTheme = this.spec.getOsTheme();
        this.addOSThemeSpecificFile(result, theme, "active-selected", osTheme.getActiveSelectedBackgroundColor());
        this.addOSThemeSpecificFile(result, theme, "active-unselected", osTheme.getActiveNonSelectedBackgroundColor());
        this.addOSThemeSpecificFile(result, theme, "inactive-selected", osTheme.getInactiveSelectedBackgroundColor());
        this.addOSThemeSpecificFile(result, theme, "inactive-unselected", osTheme.getInactiveNonSelectedBackgroundColor());
        reader.close();
    }

    private void addOSThemeSpecificFile(StringBuilder result, String theme, String state, int rgb) throws IOException {
        String[] suffices = this.getBrightnessSuffices(rgb);
        for (int i = suffices.length - 1; i >= 0; --i) {
            String line;
            URL file = RendererThemeImpl.getThemeURL(theme + "-" + state + "-" + suffices[i]);
            if (file == null) continue;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(file.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("include")) {
                    this.addThemeFile(result, line.split(" ")[1].trim());
                    continue;
                }
                result.append(theme + ":" + reader.getLineNumber() + ":" + line + "\n");
            }
        }
    }

    private static URL getThemeURL(String theme) {
        URL themeUrl = RendererThemeImpl.class.getResource("themes/" + theme + ".theme");
        return themeUrl;
    }

    @Override
    public RendererNode decorate(String tag, ModelViewer viewer, RendererNode node) {
        return this.decorate(tag, viewer, node, null);
    }

    @Override
    public RendererNode decorate(String tag, ModelViewer viewer, RendererNode node, String altImageText) {
        String alText;
        RendererNode result = node;
        String string = alText = altImageText == null ? "" : altImageText;
        if (this.prependImages.containsKey(tag)) {
            result = viewer.newMultiChildNode(viewer.newImageNode(this.prependImages.get(tag), alText), result);
        }
        if (this.appendImages.containsKey(tag)) {
            result = viewer.newMultiChildNode(result, viewer.newImageNode(this.prependImages.get(tag), alText));
        }
        if (this.colors.containsKey(tag)) {
            int[] rgb = this.colors.get(tag);
            result = viewer.newColorNode(rgb[0], rgb[1], rgb[2], rgb[3], rgb[4], rgb[5], rgb[6], result);
        }
        if (this.fontSizeChanges.containsKey(tag)) {
            result = viewer.newFontSizeChangeNode(this.fontSizeChanges.get(tag), result);
        }
        if (this.boldnessChanges.containsKey(tag)) {
            result = viewer.newChangeBoldNode(this.boldnessChanges.get(tag), result);
        }
        if (this.italicsChanges.containsKey(tag)) {
            result = viewer.newChangeItalicsNode(this.italicsChanges.get(tag), result);
        }
        return result;
    }

    @Override
    public RendererThemeSpec getSpec() {
        return this.spec;
    }

    @Override
    public int getAdditionalLeading() {
        return this.additionalLeading;
    }

    @Override
    public int getAdditionalAscent() {
        return this.additionalAscend;
    }

    @Override
    public int getAdditionalDescent() {
        return this.additionalDescend;
    }

    @Override
    public HighlightSpec getHighlightSpec() {
        return this.highlightSpec;
    }

    @Override
    public int getColor(String tag) {
        if (this.colors.containsKey(tag)) {
            int[] rgb = this.colors.get(tag);
            return rgb[0];
        }
        return 0xFF0000;
    }

    @Override
    public int[] getColors(String tag) {
        if (this.colors.containsKey(tag)) {
            return this.colors.get(tag);
        }
        return null;
    }

    private int getBrightness(int rgb) {
        int red = rgb >>> 16;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return (int)(0.212671 * (double)red + 0.71516 * (double)green + 0.072169 * (double)blue);
    }

    private String[] getBrightnessSuffices(int rgb) {
        int brightness = this.getBrightness(rgb);
        if (brightness < 32) {
            return new String[]{"dark-dark", "dark"};
        }
        if (brightness < 64) {
            return new String[]{"medium-dark", "dark"};
        }
        if (brightness < 96) {
            return new String[]{"light-dark", "dark"};
        }
        if (brightness < 128) {
            return new String[]{"dark-medium", "medium"};
        }
        if (brightness < 160) {
            return new String[]{"light-medium", "medium"};
        }
        if (brightness < 192) {
            return new String[]{"dark-light", "light"};
        }
        if (brightness < 224) {
            return new String[]{"medium-light", "light"};
        }
        return new String[]{"light-light", "light"};
    }
}

