/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.TimeDistributionEntryBase;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public abstract class SampleDistributionRendererBase
extends EntryRendererBase {
    private static final int HOUR = 3600000;
    private static final int MINUTE = 60000;
    private static final int SECONDS = 1000;
    private static final int NANOS_PER_MILLI = 1000000;

    public SampleDistributionRendererBase(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
    }

    protected final TimeDistributionEntryBase getCombinedDistribution(ProviderEntry[] entries) {
        TimeDist sum = TimeDistributionEntryBase.getSum(entries);
        return new TimeDistributionEntryBase(sum);
    }

    @Override
    public final RendererNode getRendererForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getRenderer(this.getCombinedDistribution(entries), context, columnContext);
    }

    @Override
    public final RendererNode getRendererForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getRenderer(this.getCombinedDistribution(entries), context, columnContext);
    }

    public static final String getTimeText(long time) {
        long durationMillis = time / 1000000L;
        long hours = durationMillis / 3600000L;
        long minutes = (durationMillis -= hours * 3600000L) / 60000L;
        long seconds = (durationMillis -= minutes * 60000L) / 1000L;
        String result = null;
        result = hours > 0L ? I18n._ss((String)"DurationFormat|hr_min_sec_ms", (String)"{0,number}h {1,number,00}m {2,number,00}.{3,number,000}s", (Object[])new Object[]{hours, minutes, seconds, durationMillis}) : (minutes > 0L ? I18n._ss((String)"DurationFormat|min_sec_ms", (String)"{0,number}m {1,number,00}.{2,number,000}s", (Object[])new Object[]{minutes, seconds, durationMillis}) : I18n._ss((String)"DurationFormat|sec_ms", (String)"{0,number}.{1,number,000}s", (Object[])new Object[]{seconds, durationMillis -= seconds * 1000L}));
        return result;
    }

    @Override
    public final String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTip(this.getCombinedDistribution(entries), context, columnContext);
    }

    @Override
    public final String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTipForOtherChildren(entries, context, columnContext);
    }
}

