/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.SocketObjectEntry;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.SocketObjectUsage;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class SocketObjectEntryRenderer
extends EntryRendererBase {
    public static final String PACKAGE_TAG = "classObject.package";
    public static final String CLASS_TAG = "classObject.class";
    private final Map<SocketObjectUsage, RendererNode> images;
    private final TextNode tagText;
    private final TextNode remoteHostText;
    private final TextNode remotePortText;
    private final TextNode localPortText;
    private final RendererNode smallSpace;
    private final RendererNode mediumSpace;

    public SocketObjectEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.tagText = viewer.newTextNode(null);
        this.remoteHostText = viewer.newTextNode(null);
        this.remotePortText = viewer.newTextNode(null);
        this.localPortText = viewer.newTextNode(null);
        this.smallSpace = viewer.newSpaceNode(3);
        this.mediumSpace = viewer.newSpaceNode(5);
        this.images = new HashMap<SocketObjectUsage, RendererNode>();
        for (SocketObjectUsage usage : SocketObjectUsage.values()) {
            String imageTag = "socketobjectusage.image." + usage.getTag().toLowerCase();
            String altText = usage.getUsageText();
            ArrayList<RendererNode> renderers = new ArrayList<RendererNode>();
            renderers.add(this.mediumSpace);
            renderers.add(this.tagText);
            renderers.add(this.smallSpace);
            renderers.add(viewer.newChangeBoldNode(true, this.remoteHostText));
            renderers.add(this.smallSpace);
            renderers.add(viewer.newTextNode(":"));
            renderers.add(this.smallSpace);
            renderers.add(viewer.newChangeBoldNode(true, this.remotePortText));
            if (usage != SocketObjectUsage.ACCEPTING) {
                renderers.add(this.mediumSpace);
                renderers.add(viewer.newTextNode("(local port:"));
                renderers.add(this.smallSpace);
                renderers.add(viewer.newChangeBoldNode(true, this.localPortText));
                renderers.add(viewer.newTextNode(")"));
            }
            RendererNode[] sentence = renderers.toArray(new RendererNode[0]);
            this.images.put(usage, viewer.newMultiChildNode(theme.decorate(imageTag, viewer, viewer.newMultiChildNode(sentence), altText)));
        }
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        SocketObjectEntry socketEntry = (SocketObjectEntry)entry;
        SocketObject socketObject = socketEntry.getSockeObject();
        this.tagText.setText(socketObject.getSocketUsage().getUsageText());
        this.remoteHostText.setText(socketObject.getEffectiveRemoteHostname());
        if (socketObject.getSocketUsage() == SocketObjectUsage.ACCEPTING) {
            this.remotePortText.setText(Integer.toString(socketObject.getLocalPort()));
        } else {
            this.remotePortText.setText(Integer.toString(socketObject.getRemotePort()));
            this.localPortText.setText(Integer.toString(socketObject.getLocalPort()));
        }
        return this.images.get(socketObject.getSocketUsage());
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.tagText.setText("reading from 00:00:00:00:00:00:00:00 : 0000 (local port : 00000)");
        return this.images.get(SocketObjectUsage.CONNECTING);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        StringBuilder result = new StringBuilder();
        SocketObjectEntry socketEntry = (SocketObjectEntry)entry;
        SocketObject socketObject = socketEntry.getSockeObject();
        result.append(socketObject.getSocketUsage().getUsageText());
        result.append(' ');
        result.append(socketObject.getEffectiveRemoteHostname());
        result.append(":");
        if (socketObject.getSocketUsage() == SocketObjectUsage.ACCEPTING) {
            result.append(Integer.toString(socketObject.getLocalPort()));
        } else {
            result.append(Integer.toString(socketObject.getRemotePort()));
            result.append(" (local port: ");
            result.append(Integer.toString(socketObject.getLocalPort()));
            result.append(')');
        }
        return result.toString();
    }
}

