/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MethodRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.StackFrameEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class StackFrameEntryRenderer
extends MethodRendererBase {
    public static final String TAG = "threaddump.stackframe";
    private final RendererNode rootWithLineNr;

    public StackFrameEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, TAG, theme);
        this.rootWithLineNr = viewer.newMultiChildNode(this.root, viewer.newSpaceNode(4), this.otherText);
    }

    @Override
    protected MethodLocation getLocation(ProviderEntry entry) {
        return ((StackFrameEntry)entry).getMethodLocation();
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        RendererNode parent = super.getRenderer(entry, context, columnContext);
        MethodLocation location = this.getLocation(entry);
        String fileName = location.getMethod().getMethodClass().getFilename();
        if (location.getLineNumber() != 0) {
            if (fileName != null && fileName.length() > 0) {
                this.otherText.setText(String.format("(%s:%d)", fileName, location.getLineNumber()));
            } else {
                this.otherText.setText(String.format(I18n._s((String)"(line %d)"), location.getLineNumber()));
            }
            return this.rootWithLineNr;
        }
        return parent;
    }

    @Override
    protected ClassObject getReceiver(ProviderEntry entry) {
        return null;
    }
}

