/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpThreadStates;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.BarChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class ThreadDumpThreadStatesRenderer
extends EntryRendererBase {
    private final TextNode text;
    private BarChartNode barNode;
    private static final String COLORS_TAG = "threaddump.thread.states";
    private Color clRunning;
    private Color clSleeping;
    private Color clIO;
    private Color clBlocked;
    private Color clWaiting;

    public ThreadDumpThreadStatesRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        int[] colors = theme.getColors(COLORS_TAG);
        this.clRunning = new Color(colors[0]);
        this.clSleeping = new Color(colors[1]);
        this.clIO = new Color(colors[2]);
        this.clBlocked = new Color(colors[3]);
        this.clWaiting = new Color(colors[4]);
        this.barNode = viewer.newBarChartNode();
        this.text = viewer.newTextNode(null);
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        ThreadDumpThreadStates states = (ThreadDumpThreadStates)entry;
        AccSingleBarDataSet data = new AccSingleBarDataSet();
        assert ((long)states.getMaxNumThreads() >= states.getThreadsCount());
        data.setMaxValue(Math.max((long)states.getMaxNumThreads(), states.getThreadsCount()));
        data.addValue(states.getThreadStateRunning(), this.clRunning);
        data.addValue(states.getThreadStateSleeping(), this.clSleeping);
        data.addValue(states.getThreadStateIO(), this.clIO);
        data.addValue(states.getThreadStateBlocked(), this.clBlocked);
        data.addValue(states.getThreadStateWaiting(), this.clWaiting);
        data.setInlinedText("");
        this.barNode.setData(data);
        return this.barNode;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        ThreadDumpThreadStates states = (ThreadDumpThreadStates)entry;
        return I18n._s((String)"{0} threads running\n{1} threads sleeping\n{2} threads in I/O\n{3} threads blocked\n{4} threads waiting", (Object[])new Object[]{states.getThreadStateRunning(), states.getThreadStateSleeping(), states.getThreadStateIO(), states.getThreadStateBlocked(), states.getThreadStateWaiting()});
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("A very long and synthetic string we see seldom");
        return this.text;
    }
}

