/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadStatusEntry;
import com.sap.jvm.profiling.thread.ThreadStatus;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ThreadStatusEntryRenderer
extends EntryRendererBase {
    private final RendererNode[] images;
    private final TextNode text;

    public ThreadStatusEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        int numStates = ThreadStatus.values().length;
        this.text = viewer.newTextNode(null);
        this.images = new RendererNode[numStates];
        for (int i = 0; i < numStates; ++i) {
            ThreadStatus threadStatus = ThreadStatus.getThreadState((int)i);
            String imageTag = "threadstatus.image." + threadStatus.getExportText().toLowerCase();
            String altText = threadStatus.getDisplayText();
            this.images[i] = viewer.newMultiChildNode(viewer.newSpaceNode(5), theme.decorate(imageTag, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), this.text, viewer.newSpaceNode(5)), altText), viewer.newSpaceNode(5));
        }
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        ThreadStatusEntry type = (ThreadStatusEntry)entry;
        this.text.setText(type.getDisplayText());
        int value = type.getThreadState().getValue();
        assert (value >= 0 && value < this.images.length);
        return this.images[value];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        int maxValue = -1;
        ThreadStatus maxStatus = ThreadStatus.THREAD_STATUS_UNKNOWN;
        for (ThreadStatus status : ThreadStatus.values()) {
            int statusLen = status.getDisplayText().length();
            if (statusLen <= maxValue) continue;
            maxValue = statusLen;
            maxStatus = status;
        }
        this.text.setText(maxStatus.getDisplayText());
        return this.images[maxStatus.getValue()];
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((ThreadStatusEntry)entry).getDisplayText();
    }
}

