/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.TimeZone;

public final class TimestampRenderer
extends EntryRendererBase {
    private final RendererNode root;
    private final TextNode dateNode;

    public TimestampRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.dateNode = viewer.newTextNode(null);
        this.root = viewer.newAlignNode(1, this.dateNode);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.dateNode.setText("  12/23/10 13:23:00 AM  ");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        Timestamp timestamp = (Timestamp)entry;
        long time = timestamp.getTimestamp();
        if (time == 0L) {
            this.dateNode.setText(timestamp.getMissingMessage());
        } else {
            this.dateNode.setText(DataFormatter.getTimeStampSeconds((long)time, (TimeZone)context.getSession().getTimeZone()));
        }
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        Timestamp timestamp = (Timestamp)entry;
        long time = timestamp.getTimestamp();
        if (time == 0L) {
            return timestamp.getMissingMessage();
        }
        return DataFormatter.getTimeStampLong((long)time, (TimeZone)context.getSession().getTimeZone());
    }
}

