/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbstractAxisModel;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AbsoluteTimeStampAxisModel
extends AbstractAxisModel {
    private static final long MICRO = 1L;
    private static final long MILLI = 1000L;
    private static final long SECOND = 1000000L;
    private static final long MINUTE = 60000000L;
    private static final long HOUR = 3600000000L;
    private static final long DAY = 86400000000L;
    private long originTimeStamp;
    private long rasterOrigin;
    private final ProfilingSession session;

    public AbsoluteTimeStampAxisModel(ProfilingSession session, long originTimeStamp) {
        this.session = session;
        this.originTimeStamp = originTimeStamp;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(originTimeStamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long originOffset = originTimeStamp - calendar.getTimeInMillis();
        this.rasterOrigin = -originOffset * 1000L;
    }

    @Override
    protected long[] getPossibleTickSizes() {
        return new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 20000L, 25000L, 50000L, 100000L, 200000L, 250000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 15000000L, 20000000L, 30000000L, 60000000L, 120000000L, 300000000L, 600000000L, 900000000L, 1200000000L, 1800000000L, 3600000000L, 7200000000L, 21600000000L, 43200000000L, 86400000000L, 172800000000L, 432000000000L, 864000000000L, 1728000000000L, 2160000000000L, 4320000000000L, 8640000000000L, 17280000000000L, 43200000000000L, 86400000000000L, 172800000000000L, 432000000000000L, 864000000000000L, 1728000000000000L, 4320000000000000L, 8640000000000000L, 17280000000000000L, 43200000000000000L, 8640000000000000L};
    }

    private String getTickLabel(long timeStamp, long tickSize) {
        if (tickSize >= 86400000000L) {
            return DataFormatter.getTimeStampDate((long)timeStamp, (TimeZone)this.session.getTimeZone());
        }
        if (tickSize >= 3600000000L) {
            return DataFormatter.getTimeStamp((long)timeStamp, (TimeZone)this.session.getTimeZone());
        }
        if (tickSize >= 60000000L) {
            return DataFormatter.getTimeStampTimeNoSeconds((long)timeStamp, (TimeZone)this.session.getTimeZone());
        }
        if (tickSize >= 1000000L) {
            return DataFormatter.getTimeStampTime((long)timeStamp, (TimeZone)this.session.getTimeZone());
        }
        return DataFormatter.getTimeStampTimeDetailed((long)timeStamp, (TimeZone)this.session.getTimeZone());
    }

    @Override
    public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
        return 5;
    }

    @Override
    public String getTickLabel(long tickValue, long tickSize, long min, long max) {
        long timeStamp = this.originTimeStamp + tickValue / 1000L;
        return this.getTickLabel(timeStamp, tickSize);
    }

    public double getRasterOrigin() {
        return this.rasterOrigin;
    }

    @Override
    public String getExportUnit() {
        return I18n._s((String)"seconds");
    }

    @Override
    public double getScale() {
        return 1.0E-6;
    }
}

