/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.util.pair.LongPair;

public abstract class AbstractAxisModel
implements AxisModel {
    protected static final int MAX_MAJOR_TICKS = 10;

    protected abstract long[] getPossibleTickSizes();

    @Override
    public long getMajorTickSize(long suggestedMajorTickSize, long min, long max) {
        int index;
        long[] tickSizes = this.getPossibleTickSizes();
        long diff = max - min;
        int maxTicks = Math.min(10, (int)(diff / (suggestedMajorTickSize == 0L ? 1L : suggestedMajorTickSize)));
        for (index = 0; index < tickSizes.length && (long)maxTicks * tickSizes[index] < diff; ++index) {
        }
        return tickSizes[Math.max(0, Math.min(index, tickSizes.length - 1))];
    }

    @Override
    public LongPair getRange(long min, long max) {
        long newMax = max;
        long newMin = min;
        if (newMax - newMin < 3L) {
            newMax = newMin + 3L;
        }
        long tickSize = this.getMajorTickSize(Math.max(1L, (newMax - newMin) / 10L), newMin, newMax);
        newMax = (newMax + tickSize - 1L) / tickSize * tickSize;
        newMin = Math.max(0L, newMin - (long)(0.1 * (double)((newMax += Math.max(1L, tickSize / 10L)) - newMin)));
        return new LongPair(newMin, newMax);
    }

    @Override
    public String getCaptionSuffix(long min, long max) {
        return null;
    }

    @Override
    public double getScale() {
        return 1.0;
    }

    @Override
    public String getToolTip(long tickValue) {
        return this.getTickLabel(tickValue, tickValue / 1000L, 0L, 0L);
    }
}

