/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbstractAxisModel;

public class ByteBasedAxisModel
extends AbstractAxisModel {
    private static final long k = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final long P = 0x4000000000000L;
    private static final long E = 0x1000000000000000L;
    private final String[] suffices;

    public ByteBasedAxisModel(String singleSuffix, String kiloSuffix, String megaSuffix, String gigaSuffix, String teraSuffix, String petaSuffix, String exaSuffix) {
        this.suffices = new String[]{singleSuffix, kiloSuffix, megaSuffix, gigaSuffix, teraSuffix, petaSuffix, exaSuffix};
    }

    @Override
    protected long[] getPossibleTickSizes() {
        return new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L, 250L, 500L, 1024L, 2048L, 5120L, 10240L, 20480L, 25600L, 51200L, 102400L, 204800L, 256000L, 512000L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L, 0x1900000L, 0x3200000L, 0x6400000L, 0xC800000L, 0xFA00000L, 524288000L, 0x40000000L, 0x80000000L, 0x140000000L, 0x280000000L, 0x500000000L, 0x640000000L, 0xC80000000L, 0x1900000000L, 0x3200000000L, 268435456000L, 0x7D00000000L, 0x10000000000L, 0x20000000000L, 0x50000000000L, 0xA0000000000L, 0x140000000000L, 0x190000000000L, 0x320000000000L, 0x640000000000L, 0xC80000000000L, 0xFA0000000000L, 549755813888000L, 0x4000000000000L, 0x8000000000000L, 0x14000000000000L, 0x28000000000000L, 0x50000000000000L, 0x64000000000000L, 0xC8000000000000L, 0x190000000000000L, 0x320000000000000L, 281474976710656000L, 0x7D0000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x5000000000000000L, -6917529027641081856L, 0x4000000000000000L, -8070450532247928832L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE, -6917529027641081856L, 0x4000000000000000L};
    }

    private long getScaleForTickSize(long tickSize) {
        long scale;
        for (scale = 1L; scale * 1024L < tickSize && scale < 0x1000000000000000L; scale *= 1024L) {
        }
        return scale;
    }

    private String withSuffix(long scaledValue, long scale) {
        long s = 1L;
        int i = 0;
        while (s * 1024L <= scale && s < 0x1000000000000000L) {
            s *= 1024L;
            ++i;
        }
        return DataFormatter.getUnitText((long)scaledValue, (String)this.suffices[i]);
    }

    @Override
    public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
        return 5;
    }

    @Override
    public String getTickLabel(long tickValue, long tickSize, long min, long max) {
        long scale = this.getScaleForTickSize(tickSize);
        long scaled = tickValue / scale;
        return this.withSuffix(scaled, scale);
    }

    @Override
    public String getExportUnit() {
        return I18n._s((String)"Bytes");
    }
}

