/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbstractAxisModel;

public class DurationAxisModel
extends AbstractAxisModel {
    private static final long NANO = 1L;
    private static final long MICRO = 1000L;
    private static final long MILLI = 1000000L;
    private static final long SECOND = 1000000000L;
    private static final long MINUTE = 60000000000L;
    private static final long HOUR = 3600000000000L;
    private static final long DAY = 86400000000000L;

    @Override
    protected long[] getPossibleTickSizes() {
        return new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 20000L, 25000L, 50000L, 100000L, 200000L, 250000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 25000000L, 50000000L, 100000000L, 200000000L, 250000000L, 500000000L, 1000000000L, 2000000000L, 5000000000L, 10000000000L, 20000000000L, 30000000000L, 60000000000L, 120000000000L, 300000000000L, 600000000000L, 1200000000000L, 1800000000000L, 3600000000000L, 7200000000000L, 18000000000000L, 36000000000000L, 86400000000000L, 172800000000000L, 864000000000000L, 1728000000000000L, 4320000000000000L, 8640000000000000L, 17280000000000000L, 43200000000000000L};
    }

    private long getScaleForTickSize(long tickSize) {
        if (tickSize >= 86400000000000L) {
            return 86400000000000L;
        }
        if (tickSize >= 3600000000000L) {
            return 3600000000000L;
        }
        if (tickSize >= 60000000000L) {
            return 60000000000L;
        }
        if (tickSize >= 1000000000L) {
            return 1000000000L;
        }
        if (tickSize >= 1000000L) {
            return 1000000L;
        }
        if (tickSize >= 1000L) {
            return 1000L;
        }
        return 1L;
    }

    private String withSuffix(long scaledValue, long scale) {
        String suffix;
        if (scale == 86400000000000L) {
            suffix = I18n._ss((String)"Unit|days", (String)"d");
        } else if (scale == 3600000000000L) {
            suffix = I18n._ss((String)"Unit|hours", (String)"h");
        } else if (scale == 60000000000L) {
            suffix = I18n._ss((String)"Unit|minutes", (String)"m");
        } else if (scale == 1000000000L) {
            suffix = I18n._ss((String)"Unit|seconds", (String)"s");
        } else if (scale == 1000000L) {
            suffix = I18n._ss((String)"Unit|milliseconds", (String)"ms");
        } else if (scale == 1000L) {
            suffix = I18n._ss((String)"Unit|microseconds", (String)"\u00b5s");
        } else {
            assert (scale == 1L);
            suffix = I18n._ss((String)"Unit|nanoseconds", (String)"ns");
        }
        return DataFormatter.getUnitText((long)scaledValue, (String)suffix);
    }

    @Override
    public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
        return 5;
    }

    @Override
    public String getTickLabel(long tickValue, long tickSize, long min, long max) {
        long scale = this.getScaleForTickSize(tickSize);
        long scaled = tickValue / scale;
        return this.withSuffix(scaled, scale);
    }

    @Override
    public String getExportUnit() {
        return I18n._s((String)"seconds");
    }

    @Override
    public double getScale() {
        return 1.0E-9;
    }
}

