/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.DecimalAxisModel;

public final class NumberAxisModel
extends DecimalAxisModel {
    private final String[] suffixes;

    public NumberAxisModel() {
        this.suffixes = new String[]{" (in thousands)", " (in millions)", " (in billions)"};
    }

    public NumberAxisModel(String thousands, String millions, String billions) {
        this.suffixes = new String[]{thousands, millions, billions};
    }

    private long getScale(long min, long max) {
        if (max < 4000L) {
            return 1L;
        }
        if (max < 4000000L) {
            return 1000L;
        }
        if (max < 4000000000L) {
            return 1000000L;
        }
        return 1000000000L;
    }

    private String getTitleSuffixForScale(long scale) {
        if (scale == 1L) {
            return "";
        }
        if (scale == 1000L) {
            return this.suffixes[0];
        }
        if (scale == 1000000L) {
            return this.suffixes[1];
        }
        return this.suffixes[2];
    }

    @Override
    public String getTickLabel(long tickValue, long tickSize, long min, long max) {
        long scale = this.getScale(min, max);
        return DataFormatter.getNumberText((double)(1.0 * (double)tickValue / (double)scale), (int)3);
    }

    @Override
    public String getCaptionSuffix(long min, long max) {
        long scale = this.getScale(min, max);
        String suffix = this.getTitleSuffixForScale(scale);
        return " " + suffix;
    }

    @Override
    public String getExportUnit() {
        return "";
    }
}

