/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.axis;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbstractAxisModel;
import java.text.NumberFormat;

public class TimeStampAxisModel
extends AbstractAxisModel {
    private static final long MICRO = 1L;
    private static final long MILLI = 1000L;
    private static final long SECOND = 1000000L;
    private static final long MINUTE = 60000000L;
    private static final long HOUR = 3600000000L;

    @Override
    protected long[] getPossibleTickSizes() {
        return new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 20000L, 25000L, 50000L, 100000L, 200000L, 250000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 30000000L, 60000000L, 120000000L, 300000000L, 600000000L, 1200000000L, 1800000000L, 3600000000L, 7200000000L, 18000000000L, 36000000000L, 72000000000L, 180000000000L, 360000000000L, 720000000000L, 1800000000000L, 3600000000000L, 7200000000000L, 18000000000000L, 36000000000000L, 72000000000000L, 180000000000000L, 360000000000000L, 720000000000000L, 1800000000000000L, 360000000000000L};
    }

    private long getScaleForTickSize(long tickSize) {
        if (tickSize >= 3600000000L) {
            return 3600000000L;
        }
        if (tickSize >= 60000000L) {
            return 60000000L;
        }
        if (tickSize >= 1000000L) {
            return 1000000L;
        }
        if (tickSize >= 1000L) {
            return 1000L;
        }
        return 1L;
    }

    private String withSuffix(long scaledValue, long scale) {
        if (scale == 3600000000L) {
            return this.getHHMMSS(scaledValue, 0L, 0L);
        }
        if (scale == 60000000L) {
            long minutes = scaledValue % 60L;
            long hours = scaledValue / 60L;
            return this.getHHMMSS(hours, minutes, 0L);
        }
        if (scale == 1000000L) {
            long seconds = scaledValue % 60L;
            long scaled = scaledValue / 60L;
            long minutes = scaled % 60L;
            long hours = scaled /= 60L;
            return this.getHHMMSS(hours, minutes, seconds);
        }
        if (scale == 1000L) {
            long millis = scaledValue % 1000L;
            long scaled = scaledValue / 1000L;
            long seconds = scaled % 60L;
            long minutes = (scaled /= 60L) % 60L;
            long hours = scaled /= 60L;
            return this.getHHMMSSmmm(hours, minutes, seconds, millis);
        }
        long micros = scaledValue % 1000L;
        long scaled = scaledValue / 1000L;
        long millis = scaled % 1000L;
        long seconds = (scaled /= 1000L) % 60L;
        long minutes = (scaled /= 60L) % 60L;
        long hours = scaled /= 60L;
        return this.getHHMMSSmmmuuu(hours, minutes, seconds, millis, micros);
    }

    private String getHHMMSS(long hh, long mm, long ss) {
        StringBuilder result = new StringBuilder();
        NumberFormat format = NumberFormat.getInstance(I18n.getLocale());
        result.append(format.format(hh));
        format.setMinimumIntegerDigits(2);
        format.setMaximumIntegerDigits(2);
        result.append(':');
        result.append(format.format(mm));
        result.append(':');
        result.append(format.format(ss));
        return result.toString();
    }

    private String getHHMMSSmmm(long hh, long mm, long ss, long mmm) {
        NumberFormat format = NumberFormat.getInstance(I18n.getLocale());
        format.setMinimumIntegerDigits(3);
        format.setMaximumIntegerDigits(3);
        return this.getHHMMSS(hh, mm, ss) + "." + format.format(mmm);
    }

    private String getHHMMSSmmmuuu(long hh, long mm, long ss, long mmm, long uuu) {
        NumberFormat format = NumberFormat.getInstance(I18n.getLocale());
        format.setMinimumIntegerDigits(3);
        format.setMaximumIntegerDigits(3);
        return this.getHHMMSSmmm(hh, mm, ss, mmm) + "." + format.format(uuu);
    }

    @Override
    public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
        return 5;
    }

    @Override
    public String getTickLabel(long tickValue, long tickSize, long min, long max) {
        if (tickValue < 0L) {
            return "-" + this.getTickLabel(-Math.max(tickValue, -9223372036854775807L), tickSize, min, max);
        }
        long scale = this.getScaleForTickSize(tickSize);
        long scaled = tickValue / scale;
        return this.withSuffix(scaled, scale);
    }

    @Override
    public String getExportUnit() {
        return I18n._s((String)"seconds");
    }

    @Override
    public double getScale() {
        return 1.0E-6;
    }
}

