/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;

public class BaseQuantityRendererSpec {
    private String tag;
    private String[] units;
    private long[] unitFactors;
    private String singleToolTip;
    private String snapshotToolTip;
    private String viewToolTip;
    private String parentToolTip;
    private String diffToolTip;
    private String axisToolTip;
    private long[][] factors;
    private BaseQuantity.Units unitsArg;

    public BaseQuantityRendererSpec(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof BaseQuantity.Tag) {
                this.tag = ((BaseQuantity.Tag)arg).tag;
                continue;
            }
            if (arg instanceof BaseQuantity.Units) {
                this.unitsArg = (BaseQuantity.Units)arg;
                this.units = this.unitsArg.units;
                this.unitFactors = this.unitsArg.factors;
                this.factors = this.unitsArg.scales;
                continue;
            }
            if (arg instanceof BaseQuantity.DiffToolTip) {
                this.diffToolTip = ((BaseQuantity.DiffToolTip)arg).text;
                continue;
            }
            if (arg instanceof BaseQuantity.AxisToolTip) {
                this.axisToolTip = ((BaseQuantity.AxisToolTip)arg).text;
                continue;
            }
            if (arg instanceof BaseQuantity.SingleToolTip) {
                this.singleToolTip = ((BaseQuantity.SingleToolTip)arg).text;
                continue;
            }
            if (arg instanceof BaseQuantity.SnapshotToolTip) {
                this.snapshotToolTip = ((BaseQuantity.SnapshotToolTip)arg).text;
                continue;
            }
            if (arg instanceof BaseQuantity.ViewToolTip) {
                this.viewToolTip = ((BaseQuantity.ViewToolTip)arg).text;
                continue;
            }
            if (arg instanceof BaseQuantity.ParentToolTip) {
                this.parentToolTip = ((BaseQuantity.ParentToolTip)arg).text;
                continue;
            }
            throw new RuntimeException("Unknown argument type " + arg.getClass());
        }
        assert (this.tag != null);
        if (this.singleToolTip == null) {
            this.singleToolTip = "{0}";
        }
        if (this.snapshotToolTip == null) {
            this.snapshotToolTip = I18n._ss((String)"percentage of the snapshot", (String)"{0} of the snapshot");
        }
        if (this.viewToolTip == null) {
            this.viewToolTip = I18n._ss((String)"percentage of the view", (String)"{0} of the view");
        }
        if (this.parentToolTip == null) {
            this.parentToolTip = I18n._ss((String)"percentage of the parent", (String)"{0} of the parent");
        }
        if (this.units == null) {
            this.units = new String[]{""};
            this.unitFactors = new long[]{1L};
            this.factors = new long[][]{BaseQuantity.Units.defaultScales};
        }
        if (this.diffToolTip == null) {
            this.diffToolTip = this.singleToolTip;
        }
    }

    public String getTag() {
        return this.tag;
    }

    public String[] getUnits() {
        return this.units;
    }

    public long[] getUnitFactors() {
        return this.unitFactors;
    }

    public String[] getToolTips() {
        return new String[]{this.singleToolTip, this.snapshotToolTip, this.viewToolTip, this.parentToolTip};
    }

    public long[][] getFactors() {
        return this.factors;
    }

    public String getDiffToolTip() {
        return this.diffToolTip;
    }

    public String getAxisToolTip() {
        return this.axisToolTip;
    }

    public String getAxisToolTip(long value, String valueWithUnits) {
        return I18n.formatText((String)this.axisToolTip, (Object[])new Object[]{value, valueWithUnits});
    }

    public long getMaxFromContext(EntryContext context, ColumnContext columnContext) {
        return 0L;
    }

    public int getDefaultFormat(RendererThemeSpec theme) {
        if (this.unitsArg != null) {
            return this.unitsArg.getDefaultFormat(theme);
        }
        return 0;
    }

    public BaseQuantity.Units getUnit() {
        return this.unitsArg;
    }
}

