/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity;

import com.sap.jvm.profiling.i18n.DurationFormat;
import com.sap.jvm.profiling.i18n.DurationFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.QuantityBasedRenderer;
import com.sap.jvm.profiling.viewer.ModelViewer;

public abstract class DurationBasedRenderer
extends QuantityBasedRenderer {
    private static final long ns = 1L;
    private static final long us = 1000L;
    private static final long ms = 1000000L;
    private static final long s = 1000000000L;
    private static final long m = 60000000000L;
    private static final long h = 3600000000000L;
    private static final long d = 86400000000000L;
    private static final long y = 31536000000000000L;
    private static final long[] factorsDec = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 500L};
    private static final long[] factorsSix = new long[]{1L, 2L, 5L, 10L, 20L};
    private final DurationFormatter formatter;

    public DurationBasedRenderer(ModelViewer viewer, RendererThemeImpl theme, String tagPrefix, String nsUnit, String usUnit, String msUnit, String sUnit, String mUnit, String hUnit, String dUnit, String yUnit) {
        super(viewer, theme, new String[]{nsUnit, usUnit, msUnit, sUnit, mUnit, hUnit, dUnit, yUnit}, new long[]{1L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 31536000000000000L}, new long[][]{factorsDec, factorsDec, factorsDec, factorsSix, factorsSix, factorsDec, factorsDec, factorsDec}, tagPrefix, -1);
        this.formatter = null;
    }

    public DurationBasedRenderer(ModelViewer viewer, RendererThemeImpl theme, String tagPrefix, DurationFormatter formatter) {
        super(viewer, theme, new String[]{I18n._ss((String)"Unit|nanoseconds", (String)"ns"), I18n._ss((String)"Unit|microseconds", (String)"\u00b5s"), I18n._ss((String)"Unit|milliseonds", (String)"ms"), I18n._ss((String)"Unit|seconds", (String)"s"), I18n._ss((String)"Unit|minutes", (String)"m"), I18n._ss((String)"Unit|hours", (String)"h"), I18n._ss((String)"Unit|days", (String)"d"), I18n._ss((String)"Unit|years", (String)"y")}, new long[]{1L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 31536000000000000L}, new long[][]{factorsDec, factorsDec, factorsDec, factorsSix, factorsSix, factorsDec, factorsDec, factorsDec}, tagPrefix, -1);
        this.formatter = formatter;
    }

    @Override
    protected String getQuantityText(long quantity, long max, int format) {
        if (this.formatter == null) {
            return super.getQuantityText(quantity, max, format);
        }
        return this.formatter.getDurationAsString(quantity, max);
    }

    @Override
    protected String getQuantityTextForAxis(long quantity, long max, int format) {
        if (this.formatter == null) {
            return super.getQuantityTextForAxis(quantity, max, format);
        }
        DurationFormat durationFormat = null;
        switch (format) {
            case 0: {
                durationFormat = DurationFormat.ALWAYS_NANOSECONDS;
                break;
            }
            case 1: {
                durationFormat = DurationFormat.ALWAYS_MICROSECONDS;
                break;
            }
            case 2: {
                durationFormat = DurationFormat.ALWAYS_MILLISECONDS;
                break;
            }
            case 3: {
                durationFormat = DurationFormat.ALWAYS_SECONDS;
                break;
            }
            case 4: {
                durationFormat = DurationFormat.ALWAYS_MINUTES;
                break;
            }
            case 5: {
                durationFormat = DurationFormat.ALWAYS_HOURS;
                break;
            }
            case 6: {
                durationFormat = DurationFormat.ALWAYS_DAYS;
                break;
            }
            case 7: {
                durationFormat = DurationFormat.ALWAYS_YEARS;
            }
        }
        if (durationFormat != null) {
            return new DurationFormatter(durationFormat).getDurationAsString(quantity, max);
        }
        return this.getQuantityText(quantity, max, format);
    }
}

