/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.QuantityBasedRenderer;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageDiff;
import com.sap.jvm.profiling.viewer.ModelViewer;

public class MemoryUsageRenderer
extends QuantityBasedRenderer {
    public MemoryUsageRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme, BaseQuantity.ByteUnits.defaultByteUnitNames, BaseQuantity.ByteUnits.defaultByteFactors, BaseQuantity.ByteUnits.defaultByteScales, "nrOfBytes", BaseQuantity.ByteUnits.convertByteFormat(theme.getSpec().getNrOfBytesFormat()));
    }

    @Override
    protected long getMaxFromContext(EntryContext context, ColumnContext columnContext) {
        if (context == null) {
            return 0L;
        }
        return context.getMaxMemoryUsage();
    }

    @Override
    protected String getToolTip(BaseQuantity<?> quantity, double p1, EntryContext context, ColumnContext columnContext) {
        return I18n._s((String)"{0} used ({1})", (Object[])new Object[]{this.getQuantityShortAndExact(quantity.getQuantity(), context, columnContext), this.getPercentageString(p1)});
    }

    @Override
    protected String getToolTip(BaseQuantity<?> quantity, double p1, double p2, EntryContext context, ColumnContext columnContext) {
        return I18n._s((String)"{0} used ({1})\n{2} committed ({3})", (Object[])new Object[]{this.getQuantityShortAndExact(quantity.getQuantity(), context, columnContext), this.getPercentageString(p2), this.getQuantityShortAndExact(quantity.getDisplayedQuantity(), context, columnContext), this.getPercentageString(p1)});
    }

    @Override
    protected String getDiffToolTip(Difference diffEntry, long diff, long base, double percentage, EntryContext context, ColumnContext columnContext) {
        boolean haveCommittedDiff;
        MemoryUsageDiff realDiff = (MemoryUsageDiff)diffEntry;
        StringBuilder result = new StringBuilder();
        result.append(I18n._ss((String)"Nr of bytes", (String)"{0} difference in used memoy", (Object[])new Object[]{this.getQuantityText(realDiff.getUsedBytes(), realDiff.getMaximumBytes())}));
        result.append("\n");
        result.append(I18n._ss((String)"Percentage", (String)"{0} of the other view's bytes", (Object[])new Object[]{this.getPercentageString(percentage)}));
        result.append("\n");
        result.append(I18n._s((String)"{0} used in the other view", (Object[])new Object[]{this.getQuantityShortAndExact(realDiff.getOldValue().getUsedBytes(), context, columnContext)}));
        boolean bl = haveCommittedDiff = realDiff.getOldValue().getCommittedBytes() != -1L && realDiff.getNewValue().getCommittedBytes() != -1L;
        if (haveCommittedDiff) {
            result.append("\n\n");
            result.append(I18n._ss((String)"Nr of bytes", (String)"{0} difference in committed memoy", (Object[])new Object[]{this.getQuantityText(realDiff.getCommittedBytes(), realDiff.getMaximumBytes())}));
        }
        return result.toString();
    }

    @Override
    protected double getP2(BaseQuantity<?> quantity) {
        return 1.0 * (double)quantity.getDisplayedQuantity() / (double)quantity.getTotalQuantity();
    }
}

