/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbstractAxisModel;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.QuantityRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.NumberNode;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public abstract class QuantityBasedRenderer
extends EntryRendererBase
implements QuantityRenderer {
    public static final String NUMBER_TAG = "number";
    public static final String NEG_NUMBER_TAG = "neg-number";
    public static final String POS_NUMBER_TAG = "pos-number";
    public static final String PERCENTAGE_TAG = "percentage";
    public static final String PERCENTAGE_BAR_TAG = "percentage-bar";
    private final NumberNode numberNode;
    private final PercentageBarNode percentageNode;
    private final RendererNode withoutPercentageRoot;
    private final RendererNode withoutPercentagePositiveRoot;
    private final RendererNode withoutPercentageNegativeRoot;
    private final RendererNode withPercentageRoot;
    private final RendererNode withPercentagePositiveRoot;
    private final RendererNode withPercentageNegativeRoot;
    private final int defaultFormat;
    private final String[] units;
    private final long[] scales;
    private final long[][] factors;
    private final AxisModel axisModel;
    private String valueToolTip;
    private String onePercentageToolTip;
    private String twoPercentageToolTip;
    private String threePercentageToolTip;
    private final String firstArgPattern = Pattern.quote("{0}");

    public QuantityBasedRenderer(ModelViewer viewer, RendererThemeImpl theme, String[] units, long[] scales, long[][] factors, String tagPrefix, int defaultFormat) {
        super(viewer, theme);
        this.units = units;
        this.scales = scales;
        this.factors = factors;
        this.defaultFormat = defaultFormat;
        this.axisModel = new QuantityBasedAxisModel(this);
        this.numberNode = viewer.newNumberNode();
        this.percentageNode = viewer.newPercentageBarNode();
        this.withoutPercentageRoot = viewer.newAlignNode(1, theme.decorate(tagPrefix + "." + NUMBER_TAG, viewer, this.numberNode));
        this.withoutPercentagePositiveRoot = viewer.newAlignNode(1, theme.decorate(tagPrefix + "." + POS_NUMBER_TAG, viewer, this.numberNode));
        this.withoutPercentageNegativeRoot = viewer.newAlignNode(1, theme.decorate(tagPrefix + "." + NEG_NUMBER_TAG, viewer, this.numberNode));
        this.withPercentageRoot = viewer.newAlignNode(1, viewer.newOrderedMultiChildNode(new int[]{0, 1, 2}, new RendererNode[]{theme.decorate(tagPrefix + "." + NUMBER_TAG, viewer, this.numberNode), viewer.newSpaceNode(10), theme.decorate(tagPrefix + "." + PERCENTAGE_BAR_TAG, viewer, this.percentageNode)}));
        this.withPercentagePositiveRoot = viewer.newAlignNode(1, viewer.newOrderedMultiChildNode(new int[]{0, 1, 2}, new RendererNode[]{theme.decorate(tagPrefix + "." + POS_NUMBER_TAG, viewer, this.numberNode), viewer.newSpaceNode(10), theme.decorate(tagPrefix + "." + PERCENTAGE_BAR_TAG, viewer, this.percentageNode)}));
        this.withPercentageNegativeRoot = viewer.newAlignNode(1, viewer.newOrderedMultiChildNode(new int[]{0, 1, 2}, new RendererNode[]{theme.decorate(tagPrefix + "." + NEG_NUMBER_TAG, viewer, this.numberNode), viewer.newSpaceNode(10), theme.decorate(tagPrefix + "." + PERCENTAGE_BAR_TAG, viewer, this.percentageNode)}));
        this.setToolTipTexts("{0}", "{0} of the snapshot", "{0} of the view", "{0} of the parent");
    }

    protected long getMaxFromContext(EntryContext context, ColumnContext columnContext) {
        return 0L;
    }

    protected String getToolTip(BaseQuantity<?> quantity, EntryContext context, ColumnContext columContext) {
        String v0 = this.getQuantityShortAndExact(quantity.getQuantity(), context, columContext);
        return this.formatText(this.valueToolTip, v0, quantity.getQuantity());
    }

    protected String getToolTip(BaseQuantity<?> quantity, double p1, EntryContext context, ColumnContext columContext) {
        String v0 = this.getQuantityShortAndExact(quantity.getQuantity(), context, columContext);
        String v1 = this.getPercentageString(p1);
        return this.formatText(this.onePercentageToolTip, v0, quantity.getQuantity(), v1);
    }

    protected String getToolTip(BaseQuantity<?> quantity, double p1, double p2, EntryContext context, ColumnContext columContext) {
        String v0 = this.getQuantityShortAndExact(quantity.getQuantity(), context, columContext);
        String v1 = this.getPercentageString(p1);
        String v2 = this.getPercentageString(p2);
        return this.formatText(this.twoPercentageToolTip, v0, quantity.getQuantity(), v1, v2);
    }

    protected String getToolTip(BaseQuantity<?> quantity, double p1, double p2, double p3, EntryContext context, ColumnContext columContext) {
        String v0 = this.getQuantityShortAndExact(quantity.getQuantity(), context, columContext);
        String v1 = this.getPercentageString(p1);
        String v2 = this.getPercentageString(p2);
        String v3 = this.getPercentageString(p3);
        return this.formatText(this.threePercentageToolTip, v0, quantity.getQuantity(), v1, v2, v3);
    }

    protected String getDiffToolTip(Difference entry, long base, long diff, double percentage, EntryContext context, ColumnContext columContext) {
        StringBuilder result = new StringBuilder(this.getQuantityShortAndExact(diff, context, columContext));
        result.append("\n");
        result.append(I18n._ss((String)"Percentage", (String)"{0} of the other view", (Object[])new Object[]{DataFormatter.getPercentage((double)percentage)}));
        result.append("\n");
        result.append(I18n._s((String)"{0} in the other view", (Object[])new Object[]{this.getQuantityShortAndExact(base, context, columContext)}));
        return result.toString();
    }

    protected double getP1(BaseQuantity<?> quantity) {
        if (quantity.hasTotalPercentage()) {
            return quantity.getTotalPercentage();
        }
        return -1.0;
    }

    protected double getP2(BaseQuantity<?> quantity) {
        if (quantity.hasDisplayedPercentage()) {
            return quantity.getDisplayedPercentage();
        }
        return -1.0;
    }

    protected double getP3(BaseQuantity<?> quantity) {
        if (quantity.hasParentPercentage()) {
            return quantity.getParentPercentage();
        }
        return -1.0;
    }

    protected final void setToolTipTexts(String valueText, String p1Text, String p2Text, String p3Text) {
        this.valueToolTip = valueText;
        this.onePercentageToolTip = valueText + "\n" + p1Text.replaceAll(this.firstArgPattern, "{2}");
        this.twoPercentageToolTip = valueText + "\n" + p2Text.replaceAll(this.firstArgPattern, "{2}") + "\n" + p1Text.replaceAll(this.firstArgPattern, "{3}");
        this.threePercentageToolTip = valueText + "\n" + p3Text.replaceAll(this.firstArgPattern, "{2}") + "\n" + p2Text.replaceAll(this.firstArgPattern, "{3}") + "\n" + p1Text.replaceAll(this.firstArgPattern, "{4}");
    }

    protected final String getPercentageString(double percentage) {
        return DataFormatter.getPercentage((double)percentage);
    }

    @Override
    public AxisModel getAxisModel() {
        return this.axisModel;
    }

    private long getMaxFromContext(long quantity, EntryContext context, ColumnContext columnContext) {
        long max = 0L;
        if (columnContext != null || context != null) {
            max = this.getMaxFromContext(context, columnContext);
        }
        if (max == 0L) {
            return quantity;
        }
        return max;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        BaseQuantity value = (BaseQuantity)entry;
        if (value.isDiff()) {
            return this.getDiffRenderer((Difference)entry, context, columnContext);
        }
        boolean showSign = value.showSign();
        long quantity = value.getQuantity();
        long contextMax = this.getMaxFromContext(context, columnContext);
        contextMax = contextMax == -1L ? 0L : contextMax;
        long maxValue = contextMax == 0L ? quantity : contextMax;
        this.numberNode.setNumber(quantity, (showSign && quantity > 0L ? "+ " : "") + this.getQuantityText(quantity, maxValue));
        double p1 = this.getP1(value);
        if (p1 >= 0.0) {
            double p2 = this.getP2(value);
            if (p2 >= 0.0) {
                double p3 = this.getP3(value);
                if (p3 >= 0.0) {
                    this.percentageNode.setPercentage(p3, p2, p1);
                } else {
                    this.percentageNode.setPercentage(p2, p1, 0.0);
                }
            } else {
                this.percentageNode.setPercentage(p1, 0.0, 0.0);
            }
            return !showSign || quantity == 0L ? this.withPercentageRoot : (quantity > 0L ? this.withPercentagePositiveRoot : this.withPercentageNegativeRoot);
        }
        if (value.asPercentageOfMax() && contextMax != 0L) {
            this.percentageNode.setPercentage(1.0 * (double)quantity / (double)maxValue, 0.0, 0.0);
            return !showSign || quantity == 0L ? this.withPercentageRoot : (quantity > 0L ? this.withPercentagePositiveRoot : this.withPercentageNegativeRoot);
        }
        return !showSign || quantity == 0L ? this.withoutPercentageRoot : (quantity > 0L ? this.withoutPercentagePositiveRoot : this.withoutPercentageNegativeRoot);
    }

    private RendererNode getDiffRenderer(Difference entry, EntryContext context, ColumnContext columnContext) {
        long base = ((BaseQuantity)entry.getOldValue()).getQuantity();
        long diff = ((BaseQuantity)entry.getNewValue()).getQuantity() - base;
        this.numberNode.setNumber(diff, (diff > 0L ? "+ " : "") + this.getQuantityText(diff, this.getMaxFromContext(diff, context, columnContext)));
        return diff == 0L ? this.withoutPercentageRoot : (diff > 0L ? this.withoutPercentagePositiveRoot : this.withoutPercentageNegativeRoot);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        ArrayList<Long> probes = new ArrayList<Long>();
        for (int i = 0; i < this.scales.length; ++i) {
            long unit = this.scales[i];
            long nextUnit = i == this.scales.length - 1 ? this.scales[i] : this.scales[i + 1];
            probes.add(nextUnit - 1L);
            for (long factor : this.factors[i]) {
                probes.add(unit * factor);
            }
        }
        long maxValue = this.getMaxFromContext(0L, context, columnContext);
        int maxWidth = 0;
        Iterator iterator = probes.iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            if (maxValue > 0L && value > maxValue) continue;
            String text = this.getQuantityText(value, maxValue) + " ";
            long oldValue = this.numberNode.getNumber();
            String oldText = this.numberNode.getFormattedNumber();
            this.numberNode.setNumber(value, text);
            int width = info.getWidth(this.withPercentageRoot);
            if (width > maxWidth) {
                maxWidth = width;
                continue;
            }
            this.numberNode.setNumber(oldValue, oldText);
        }
        if (columnContext != null && columnContext.noPercentageBars) {
            return this.withoutPercentagePositiveRoot;
        }
        return this.withPercentageRoot;
    }

    private BaseQuantity<?> getCombinedQuantity(Object[] entries) {
        long sum = 0L;
        long total1 = 0L;
        long total2 = 0L;
        long total3 = 0L;
        boolean hasPercentage1 = false;
        boolean hasPercentage2 = false;
        boolean hasPercentage3 = false;
        boolean showSign = false;
        boolean hasEntry = false;
        BaseQuantity value = null;
        for (Object entry : entries) {
            if (entry == null) continue;
            hasEntry = true;
            value = (BaseQuantity)entry;
            sum += value.getQuantity();
            double p1 = this.getP1(value);
            if (p1 >= 0.0) {
                double p3 = this.getP3(value);
                double p2 = this.getP2(value);
                if (p3 >= 0.0) {
                    total3 = value.getParentQuantity();
                    hasPercentage3 = true;
                }
                if (p2 >= 0.0) {
                    total2 = value.getDisplayedQuantity();
                    hasPercentage2 = true;
                }
                total1 = value.getTotalQuantity();
                hasPercentage1 = true;
            }
            showSign |= value.showSign();
        }
        if (hasPercentage3) {
            return value.create(sum, total1, total2, total3);
        }
        if (hasPercentage2) {
            return value.create(sum, total1, total2);
        }
        if (hasPercentage1) {
            return value.create(sum, total1, showSign);
        }
        if (hasEntry) {
            return value.create(sum);
        }
        return null;
    }

    private BaseQuantity<?> getCombinedQuantityDiff(Object[] entries) {
        long totalDiff = 0L;
        boolean showSign = true;
        BaseQuantity value = null;
        for (Object entry : entries) {
            if (entry == null) continue;
            value = (BaseQuantity)entry;
            totalDiff += value.getDiffValue();
        }
        return NrOfObjects.PROTOTYPE.create(totalDiff, -1L, showSign);
    }

    @Override
    public RendererNode getRendererForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        BaseQuantity<?> combined;
        boolean assumeDiff = entries.length > 0 && entries[0] instanceof BaseQuantity && ((BaseQuantity)entries[0]).isDiff();
        BaseQuantity<?> baseQuantity = combined = assumeDiff ? this.getCombinedQuantityDiff(entries) : this.getCombinedQuantity(entries);
        if (combined == null) {
            return null;
        }
        boolean showSign = combined.showSign();
        long sum = combined.getQuantity();
        this.numberNode.setNumber(sum, (showSign && sum > 0L ? "+ " : "") + this.getQuantityText(sum, this.getMaxFromContext(sum, context, columnContext)));
        if (combined.hasParentPercentage()) {
            this.percentageNode.setPercentage(combined.getParentPercentage(), combined.getDisplayedPercentage(), combined.getTotalPercentage());
            return !showSign || sum == 0L ? this.withPercentageRoot : (sum > 0L ? this.withPercentagePositiveRoot : this.withPercentageNegativeRoot);
        }
        if (combined.hasDisplayedPercentage()) {
            this.percentageNode.setPercentage(combined.getDisplayedPercentage(), combined.getTotalPercentage(), 0.0);
            return !showSign || sum == 0L ? this.withPercentageRoot : (sum > 0L ? this.withPercentagePositiveRoot : this.withPercentageNegativeRoot);
        }
        if (combined.hasPercentage()) {
            this.percentageNode.setPercentage(combined.getTotalPercentage(), 0.0, 0.0);
            return !showSign || sum == 0L ? this.withPercentageRoot : (sum > 0L ? this.withPercentagePositiveRoot : this.withPercentageNegativeRoot);
        }
        return !showSign || sum == 0L ? this.withoutPercentageRoot : (sum > 0L ? this.withoutPercentageRoot : this.withoutPercentageRoot);
    }

    @Override
    public RendererNode getRendererForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getRendererForOtherChildren(entries, context, columnContext);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (entry == null) {
            return "";
        }
        BaseQuantity value = (BaseQuantity)entry;
        if (value.isDiff()) {
            Difference diffEntry = (Difference)entry;
            long base = ((BaseQuantity)diffEntry.getOldValue()).getQuantity();
            long diff = ((BaseQuantity)diffEntry.getNewValue()).getQuantity() - base;
            double percentage = Math.abs((double)diff / (double)base);
            return this.getDiffToolTip(diffEntry, base, diff, base == 0L ? 0.0 : percentage, context, columnContext);
        }
        double p1 = this.getP1(value);
        if (p1 >= 0.0) {
            double p2 = this.getP2(value);
            if (p2 >= 0.0) {
                double p3 = this.getP3(value);
                if (p3 >= 0.0) {
                    return this.getToolTip(value, p3, p2, p1, context, columnContext);
                }
                return this.getToolTip(value, p2, p1, context, columnContext);
            }
            return this.getToolTip(value, p1, context, columnContext);
        }
        return this.getToolTip(value, context, columnContext);
    }

    protected final String getQuantityShortAndExact(long quantity, EntryContext context, ColumnContext columnContext) {
        long max = this.getMaxFromContext(quantity, context, columnContext);
        long abs = Math.abs(quantity);
        String unit = "";
        long exact = quantity;
        if (this.units != null && this.units.length > 0) {
            int largestUnitIdx = 0;
            int i = 1;
            while (i < this.units.length && abs > this.scales[i] && abs % this.scales[i] == 0L) {
                exact = quantity / this.scales[i];
                largestUnitIdx = i++;
            }
            unit = this.units[largestUnitIdx];
        }
        if (this.scales.length > 1 && abs >= this.scales[1]) {
            return this.getQuantityText(quantity, max, -1) + " (" + DataFormatter.getUnitText((long)exact, (String)unit) + ")";
        }
        return DataFormatter.getUnitText((long)quantity, (String)unit);
    }

    public String getPercentageText(double percentage) {
        return DataFormatter.getPercentage((double)percentage);
    }

    public String getQuantityText(long quantity, long max) {
        return this.getQuantityText(quantity, max, this.defaultFormat);
    }

    protected String getTextForFormat(long scale, long quantity, int format, String unit) {
        double asFraction = (double)quantity / (double)scale;
        double abs = Math.abs(asFraction);
        if (scale == 1L || abs >= 100.0) {
            return DataFormatter.getUnitText((double)asFraction, (int)0, (String)unit);
        }
        if (abs >= 10.0) {
            return DataFormatter.getUnitText((double)asFraction, (int)1, (String)unit);
        }
        return DataFormatter.getUnitText((double)asFraction, (int)2, (String)unit);
    }

    public int getScale(long quantity) {
        int curr;
        for (curr = this.scales.length - 1; quantity < this.scales[curr] && curr != 0; --curr) {
        }
        return curr;
    }

    protected String getQuantityTextForAxis(long quantity, long max, int format) {
        return this.getQuantityText(quantity, max, format);
    }

    protected String getQuantityText(long quantity, long max, int format) {
        long abs = Math.abs(format == -2 && max > 0L ? max : quantity);
        if (format >= 0) {
            return DataFormatter.getUnitText((double)((double)quantity / (double)this.scales[format]), (int)0, (String)this.units[format]);
        }
        int scale = this.getScale(abs);
        return this.getTextForFormat(this.scales[scale], quantity, scale, this.units[scale]);
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        boolean assumeDiff = entries.length > 0 && entries[0] instanceof BaseQuantity && ((BaseQuantity)entries[0]).isDiff();
        BaseQuantity<?> combined = assumeDiff ? this.getCombinedQuantityDiff(entries) : this.getCombinedQuantity(entries);
        return this.getToolTip(combined, context, columnContext);
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTipForOtherChildren(entries, context, columnContext);
    }

    protected String getAxisToolTip(long value) {
        String v0 = this.getQuantityShortAndExact(value, null, null);
        return this.formatText(this.valueToolTip, v0, value);
    }

    public static class QuantityBasedAxisModel
    extends AbstractAxisModel {
        private final QuantityBasedRenderer renderer;

        public QuantityBasedAxisModel(QuantityBasedRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        protected long[] getPossibleTickSizes() {
            ArrayList<Long> ticks = new ArrayList<Long>();
            for (int i = 0; i < this.renderer.scales.length; ++i) {
                for (long factor : this.renderer.factors[i]) {
                    ticks.add(this.renderer.scales[i] * factor);
                }
            }
            long[] result = new long[ticks.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Long)ticks.get(i);
            }
            return result;
        }

        @Override
        public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
            return 5;
        }

        @Override
        public String getTickLabel(long tickValue, long tickSize, long min, long max) {
            int scaleIndex = this.renderer.getScale(tickSize);
            return this.renderer.getQuantityTextForAxis(tickValue, 0L, scaleIndex);
        }

        @Override
        public String getExportUnit() {
            return this.renderer.units[0];
        }

        @Override
        public String getToolTip(long tickValue) {
            return this.renderer.getAxisToolTip(tickValue);
        }
    }
}

