/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.BaseQuantityRendererSpec;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.QuantityBasedRenderer;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.viewer.ModelViewer;

public class SpecBasedRenderer
extends QuantityBasedRenderer {
    private final BaseQuantityRendererSpec spec;

    public SpecBasedRenderer(ModelViewer viewer, RendererThemeImpl theme, BaseQuantityRendererSpec spec) {
        super(viewer, theme, spec.getUnits(), spec.getUnitFactors(), spec.getFactors(), spec.getTag(), spec.getDefaultFormat(theme.getSpec()));
        this.setToolTipTexts(spec.getToolTips()[0], spec.getToolTips()[1], spec.getToolTips()[2], spec.getToolTips()[3]);
        this.spec = spec;
    }

    @Override
    protected long getMaxFromContext(EntryContext context, ColumnContext columnContext) {
        return this.spec.getMaxFromContext(context, columnContext);
    }

    @Override
    protected String getDiffToolTip(Difference entry, long base, long diff, double percentage, EntryContext context, ColumnContext columContext) {
        return I18n.formatText((String)this.spec.getDiffToolTip(), (Object[])new Object[]{this.getQuantityShortAndExact(diff, context, columContext), this.getPercentageString(percentage), this.getQuantityShortAndExact(base, context, columContext)});
    }

    @Override
    protected String getAxisToolTip(long value) {
        String text = this.spec.getAxisToolTip();
        if (text == null) {
            return super.getAxisToolTip(value);
        }
        return this.spec.getAxisToolTip(value, this.getQuantityShortAndExact(value, null, null));
    }
}

