/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.sync.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationTableProvider;
import com.sap.jvm.profiling.presentation.typed.ThreadAnnotationUtil;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadAnnotationContext;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.sync.BlockedThreadAnnotationStatistic;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class BlockedThreadAnnotationStatisticProvider
extends SynchronizationTableProvider<BlockedThreadAnnotationStatistic> {
    private ThreadAnnotationContext annotationContext;

    public BlockedThreadAnnotationStatisticProvider(ResourceName name) {
        super(name, ThreadAnnotationUtil.getBlockedAnnotationTitle(name), ThreadAnnotationUtil.getAnnotationIconKey(name), ProviderUtils.getBlockedTimeAndCountSpec(name, I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was blocked", (Object[])new Object[]{ThreadAnnotationUtil.getContext(name).getActiveEntityText()}), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was blocked", (Object[])new Object[]{ThreadAnnotationUtil.getContext(name).getActiveEntityText()})).prepend(ThreadAnnotationUtil.getContext(name).getColumnDescription(), ThreadAnnotationUtil.getContext(name).getToolTip(), 41, NormalThreadAnnotation.class, ThreadAnnotationUtil.getContext(name).getKey()));
        this.annotationContext = ThreadAnnotationUtil.getContext(name);
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadAnnotation(((UTF8String)((BlockedThreadAnnotationStatistic)this.statistic).getKey(entryId)).toString(), this.annotationContext);
        }
        return ProviderUtils.getEntry(entryId, column - 1, (ValueStatistic)this.statistic, (SynchronizationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((BlockedThreadAnnotationStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 1, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateBlockedThreadAnnotationStatistic(this.annotationContext.getSlot()));
    }
}

