/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.graph.ProfilingColors;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTimePerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBlockedEventsPerSecond;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.ui.graph.renderer.Color;

public final class BlockedTimeSeriesProvider
extends TypedTimeSeriesProvider {
    public BlockedTimeSeriesProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Blocked Rates"), "views/graph.gif", "sync/blocked");
        String color1 = Color.darker(ProfilingColors.SYNCHRONIZATION_COLOR).getString();
        String color2 = ProfilingColors.ALLOCATION_COLOR.getString();
        this.setCurrent(this.getCollectionName(), 2);
        this.addGroup("sync", I18n._s((String)"Blocked Synchronization Rates"));
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Blocked Synchronization"), "sync/blocked", I18n._s((String)"Shows the number of block events and the corresponding blocked time"));
        this.addLine(0, 0, 1, I18n._s((String)"Blocked Events per second"), color1, NrOfBlockedEventsPerSecond.class);
        this.addLine(1, 0, 1, I18n._s((String)"Blocked Time per second"), color2, ElapsedTimePerSecond.class);
        this.addGeneralTimeSeries();
    }

    @Override
    protected ResourceName getCollectionName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateBlockedTimeSeriesCollection());
    }
}

