/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.sync.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import com.sap.jvm.profiling.snapshot.sync.BlockingEventStatistic;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class BlockingEventStatisticProvider
extends SynchronizationTableProvider<BlockingEventStatistic> {
    public BlockingEventStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Blocking Events"), "views/synchronization_events.gif", ProviderUtils.getBlockingTimeAndCountSpec(name, I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time this event was blocking anything"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times this event was blocking anything")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Index"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The index of the blocking event"), 41, NormalSynchronizationEventId.class, "synchronization_event_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalSynchronizationEventId((SynchronizationEventId)((BlockingEventStatistic)this.statistic).getKey(entryId));
        }
        return ProviderUtils.getEntry(entryId, column - 1, (ValueStatistic)this.statistic, (SynchronizationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((BlockingEventStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 1, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateBlockingEventStatistic());
    }
}

