/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.sync.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.sync.BlockingMonitorStatistic;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.sync.MonitorObjectColumn;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class BlockingMonitorStatisticProvider
extends SynchronizationTableProvider<BlockingMonitorStatistic> {
    public BlockingMonitorStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Blocking Monitors"), "views/monitors.gif", ProviderUtils.getBlockingTimeAndCountSpec(name, I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time this monitor was blocking anything"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times this monitor was blocking anything")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class of the object monitor"), 9, NormalClass.class, "class_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The object monitor id"), 8225, NormalMonitorId.class, "monitor_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalMonitorId(((MonitorObject)((BlockingMonitorStatistic)this.statistic).getKey(entryId)).getObjectId());
        }
        if (column == 1) {
            return new NormalClass(((MonitorObject)((BlockingMonitorStatistic)this.statistic).getKey(entryId)).getClassObject());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (ValueStatistic)this.statistic, (SynchronizationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((MonitorObjectColumn)((BlockingMonitorStatistic)this.statistic).getKeyColumn()).getObjectIdColumn();
        }
        if (columnIndex == 1) {
            return ((MonitorObjectColumn)((BlockingMonitorStatistic)this.statistic).getKeyColumn()).getClassColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 2, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateBlockingMonitorStatistic());
    }
}

