/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.sync.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndName;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndNameColumn;
import com.sap.jvm.profiling.snapshot.sync.BlockingThreadIdStatistic;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class BlockingThreadIdStatisticProvider
extends SynchronizationTableProvider<BlockingThreadIdStatistic> {
    public BlockingThreadIdStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Blocking Threads By ID"), "views/thread_statistic.gif", ProviderUtils.getBlockingTimeAndCountSpec(name, I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time this thread was blocking another thread"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times this thread was blocking another thread")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the thread"), 9, NormalThreadName.class, "thread_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The thread id"), 8225, NormalThreadId.class, "thread_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadId(((ThreadIdAndName)((BlockingThreadIdStatistic)this.statistic).getKey(entryId)).getId());
        }
        if (column == 1) {
            return new NormalThreadName(((ThreadIdAndName)((BlockingThreadIdStatistic)this.statistic).getKey(entryId)).getUTFName());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (ValueStatistic)this.statistic, (SynchronizationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ThreadIdAndNameColumn)((BlockingThreadIdStatistic)this.statistic).getKeyColumn()).getIdColumn();
        }
        if (columnIndex == 1) {
            return ((ThreadIdAndNameColumn)((BlockingThreadIdStatistic)this.statistic).getKeyColumn()).getNameColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 2, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateBlockingThreadIdStatistic());
    }
}

