/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBlockedEvents;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCountColumn;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;

public final class ProviderUtils {
    public static TypedColumnSpec getBlockedTimeAndCountSpec(ResourceName name, String blockTimeTooltip, String blockCountTooltip) {
        TypedColumnSpec spec = new TypedColumnSpec("BlockedTime|BlockCount");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Blocked Time"), blockTimeTooltip, 12358, ElapsedTime.class, "blocked_on_monitor_time_nanoseconds", new VisibilitySet("BlockedTime", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_blocking_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Blocked time"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Block Count"), blockCountTooltip, 12550, NrOfBlockedEvents.class, "nr_monitor_blocked_events", new VisibilitySet("BlockCount", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Count"), "tables/col_blocking_count.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Block count"), new Integer[0]));
        return spec;
    }

    public static TypedColumnSpec getBlockedSelfAndTotalSpec(ResourceName name, String entity, boolean sortBySelf, SumBehavior sumBehavior) {
        int sumSelf = 0x3000 | (sumBehavior.sumSelf() ? 4 : 0);
        int sumTotal = 0x3000 | (sumBehavior.sumTotal() ? 4 : 0);
        VisibilitySet time = new VisibilitySet("BlockedTime", "1-DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_blocking_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Blocked time"), new Integer[0]);
        VisibilitySet count = new VisibilitySet("BlockCount", "1-DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Count"), "tables/col_blocking_count.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Block count"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("BlockedTime|BlockCount|Self|Total");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Blocked Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was directly blocked", (Object[])new Object[]{entity}), 2 | sumSelf | (sortBySelf ? 64 : 0), ElapsedTime.class, "self_blocked_on_monitor_time_nanoseconds", time, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Blocked Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was directly blocked and indirectly blocked in methods called by it", (Object[])new Object[]{entity}), 2 | sumTotal | (sortBySelf ? 0 : 64), ElapsedTime.class, "total_blocked_on_monitor_time_nanoseconds", time, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Block Count"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was directly blocked", (Object[])new Object[]{entity}), 2 | sumSelf | (sortBySelf ? 256 : 0) | 0x8000, NrOfBlockedEvents.class, "self_nr_monitor_blocked_events", count, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Block Count"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was directly blocked and indirectly blocked in methods called by it", (Object[])new Object[]{entity}), 2 | sumTotal | (sortBySelf ? 0 : 256) | 0x8000, NrOfBlockedEvents.class, "total_nr_monitor_blocked_events", count, total);
        return spec;
    }

    public static TypedColumnSpec getBlockingTimeAndCountSpec(ResourceName name, String blockTimeTooltip, String blockCountTooltip) {
        TypedColumnSpec spec = new TypedColumnSpec("BlockedTime|BlockCount");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Blocking Time"), blockTimeTooltip, 12358, ElapsedTime.class, "blocked_on_monitor_time_nanoseconds", new VisibilitySet("BlockedTime", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_blocking_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Blocked time"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Blocking Count"), blockCountTooltip, 12550, NrOfBlockedEvents.class, "nr_monitor_blocked_events", new VisibilitySet("BlockCount", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Count"), "tables/col_blocking_count.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Block count"), new Integer[0]));
        return spec;
    }

    public static TypedColumnSpec getBlockingSelfAndTotalSpec(ResourceName name, String entity, String otherEntity, boolean sortBySelf, SumBehavior sumBehavior) {
        int sumSelf = 0x3000 | (sumBehavior.sumSelf() ? 4 : 0);
        int sumTotal = 0x3000 | (sumBehavior.sumTotal() ? 4 : 0);
        VisibilitySet time = new VisibilitySet("BlockedTime", "1-DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_blocking_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Blocked time"), new Integer[0]);
        VisibilitySet count = new VisibilitySet("BlockCount", "1-DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Count"), "tables/col_blocking_count.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Block count"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("BlockedTime|BlockCount|Self|Total");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Blocking Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was directly blocking {1}", (Object[])new Object[]{entity, otherEntity}), 2 | sumSelf | (sortBySelf ? 64 : 0), ElapsedTime.class, "self_blocked_on_monitor_time_nanoseconds", time, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Blocking Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was directly blocking {1} or indirectly blocking another {1} in methods called by it", (Object[])new Object[]{entity, otherEntity}), 2 | sumTotal | (sortBySelf ? 0 : 64), ElapsedTime.class, "total_blocked_on_monitor_time_nanoseconds", time, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Blocking Count"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was directly blocking {1}", (Object[])new Object[]{entity, otherEntity}), 2 | sumSelf | (sortBySelf ? 256 : 0) | 0x8000, NrOfBlockedEvents.class, "self_nr_monitor_blocked_events", count, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Blocking Count"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was directly blocking {1} or indirectly blocking {1} in methods called by it", (Object[])new Object[]{entity, otherEntity}), 2 | sumTotal | (sortBySelf ? 0 : 256) | 0x8000, NrOfBlockedEvents.class, "total_nr_monitor_blocked_events", count, total);
        return spec;
    }

    public static TypedColumnSpec getWaitingThreadSpec(ResourceName name, String entity) {
        TypedColumnSpec spec = new TypedColumnSpec("WaitingTime|WaitCount");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Waiting Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time {0} was waiting", (Object[])new Object[]{entity}), 12358, ElapsedTime.class, "waiting_time_nanoseconds", new VisibilitySet("WaitingTime", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_waiting_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Waiting time"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Wait Count"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was waiting", (Object[])new Object[]{entity}), 12550, NrOfBlockedEvents.class, "nr_waiting_events", new VisibilitySet("WaitCount", "DurationAndCount", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Count"), "tables/col_waiting_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Wait count"), new Integer[0]));
        return spec;
    }

    public static LongValueColumn getColumn(int column, SelfAndTotalValueStatistic<?, TimeAndCount> statistic) {
        if ((column & 1) == 0) {
            return ProviderUtils.getColumn((TimeAndCountColumn)statistic.getSelfColumn(), column / 2);
        }
        return ProviderUtils.getColumn((TimeAndCountColumn)statistic.getTotalColumn(), column / 2);
    }

    public static Quantity getEntry(int id, int column, SelfAndTotalValueStatistic<?, TimeAndCount> statistic, SynchronizationProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(statistic.getSelf(id), column / 2, statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry(statistic.getTotal(id), column / 2, statistic.getTotal(), provider);
    }

    private static LongValueColumn getColumn(TimeAndCountColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getTimeColumn();
            }
            case 1: {
                return column.getCountColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(TimeAndCount value, int column, TimeAndCount total, SynchronizationProvider provider) {
        switch (column) {
            case 0: {
                return ElapsedTime.PROTOTYPE.create(value.getDuration(), total.getDuration());
            }
            case 1: {
                return NrOfBlockedEvents.PROTOTYPE.create(value.getCount(), total.getCount());
            }
        }
        assert (false);
        return null;
    }

    public static Quantity getEntry(SelfAndTotalValueTreeNode<?, TimeAndCount> node, int column, ValueTreeBase<?, TimeAndCount, ?> tree, SynchronizationProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(node.getSelf(), column / 2, tree.getTotal(), provider);
        }
        return ProviderUtils.getEntry(node.getTotal(), column / 2, tree.getTotal(), provider);
    }

    public static Quantity getEntry(ValueTreeNode<?, TimeAndCount> node, int column, ValueTreeBase<?, TimeAndCount, ?> tree, SynchronizationProvider provider) {
        assert (column == 0 || column == 1);
        return ProviderUtils.getEntry(node.getValue(), column, tree.getTotal(), provider);
    }

    public static LongValueColumn getColumn(int column, ValueStatistic<?, TimeAndCount> statistic) {
        return ProviderUtils.getColumn((TimeAndCountColumn)statistic.getValueColumn(), column);
    }

    public static Quantity getEntry(int id, int column, ValueStatistic<?, TimeAndCount> statistic, SynchronizationProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }
}

