/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.sync.ProviderUtils;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.sync.SynchronizationTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndName;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndNameColumn;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.sync.WaitingThreadIdStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class WaitingThreadIdStatisticProvider
extends SynchronizationTableProvider<WaitingThreadIdStatistic> {
    public WaitingThreadIdStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Waiting Threads By ID"), "views/thread_statistic.gif", ProviderUtils.getWaitingThreadSpec(name, I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this thread")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the thread"), 9, NormalThreadName.class, "thread_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The thread id"), 8225, NormalThreadId.class, "thread_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadId(((ThreadIdAndName)((WaitingThreadIdStatistic)this.statistic).getKey(entryId)).getId());
        }
        if (column == 1) {
            return new NormalThreadName(((ThreadIdAndName)((WaitingThreadIdStatistic)this.statistic).getKey(entryId)).getUTFName());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (ValueStatistic)this.statistic, (SynchronizationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ThreadIdAndNameColumn)((WaitingThreadIdStatistic)this.statistic).getKeyColumn()).getIdColumn();
        }
        if (columnIndex == 1) {
            return ((ThreadIdAndNameColumn)((WaitingThreadIdStatistic)this.statistic).getKeyColumn()).getNameColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 2, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateWaitingThreadIdStatistic());
    }
}

