/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.ThreadAnnotationUtil;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadAnnotationContext;
import com.sap.jvm.profiling.presentation.typed.tbs.Elements;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.tbs.CalledThreadAnnotationStatistic;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class CalledThreadAnnotationStatisticProvider
extends PerformanceHotspotTableProvider<CalledThreadAnnotationStatistic> {
    private ThreadAnnotationContext annotationContext;

    public CalledThreadAnnotationStatisticProvider(ResourceName name) {
        super(name, ThreadAnnotationUtil.getAnnotationTitle(name), ThreadAnnotationUtil.getAnnotationIconKey(name), ProviderUtils.getSelfAndTotalSpec(name, I18n._ss((String)"Entity, ex: total time {0} was running", (String)"the method"), false, false, SumBehavior.SUM_SELF).prepend(CalledThreadAnnotationStatisticProvider.getContext(name).getColumnDescription(), CalledThreadAnnotationStatisticProvider.getContext(name).getToolTip(), 73, NormalThreadAnnotation.class, CalledThreadAnnotationStatisticProvider.getContext(name).getKey()));
        this.annotationContext = CalledThreadAnnotationStatisticProvider.getContext(name);
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadAnnotation(((UTF8String)((CalledThreadAnnotationStatistic)this.statistic).getKey(entryId)).toString(), this.annotationContext);
        }
        return ProviderUtils.getEntry(entryId, column - 1, (SelfAndTotalValueStatistic)this.statistic, (PerformanceHotspotProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((CalledThreadAnnotationStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumn((SelfAndTotalValueStatistic)this.statistic, columnIndex - 1);
    }

    private static ThreadAnnotationContext getContext(ResourceName name) {
        Elements.CreateCalledThreadAnnotationStatisticProvider providerElement = (Elements.CreateCalledThreadAnnotationStatisticProvider)name.getLastElement();
        ProfilingSession session = name.getSession();
        UTF8String key = session.getAnnotationKey(providerElement.getAnnotationSlot());
        UTF8String desc = session.getAnnotationDescription(providerElement.getAnnotationSlot());
        return new ThreadAnnotationContext(providerElement.getAnnotationSlot(), key == null ? null : key.toString(), desc == null ? null : desc.toString());
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateCalledThreadAnnotationStatistic(this.annotationContext.getSlot()));
    }
}

