/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotValueSetProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.MethodTypeStatistic;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;

public class CompiledVsInterpretedProvider
extends PerformanceHotspotValueSetProvider<MethodTypeStatistic, RunningType> {
    public CompiledVsInterpretedProvider(ResourceName name) {
        super(ProviderUtils.getSimpleSampleSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"methods")), I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Compiled Vs. Interpreted"), "profiling/compiled_vs_interpreted.gif", name);
    }

    @Override
    protected ResourceName getStatisticName() {
        ResourceName baseName = this.getResourceName().stripLastElement();
        ProfilingSession session = baseName.getSession();
        return baseName.addElement((ResourceNameElement)new Elements.CreateMethodTypeStatistic(new MethodFilter[]{new MethodFilter(ClassFilter.createAny(session, "<any>"), "<any>")}));
    }

    @Override
    public int getNrOfRows() {
        return 3;
    }

    @Override
    public String getRowColorTag(int row) {
        return (new String[]{"performance.graph.compiled", "performance.graph.interpreted", "performance.graph.native"})[row];
    }

    @Override
    public String getRowName(int row) {
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Native")})[row];
    }

    @Override
    public String getRowToolTip(int row) {
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in interpreted methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in native methods")})[row];
    }

    @Override
    public RunningType getRowType(int row) {
        switch (row) {
            case 0: {
                return RunningType.COMPILED;
            }
            case 1: {
                return RunningType.INTERPRETED;
            }
            case 2: {
                return RunningType.NATIVE;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Quantity getEntry(int row, int column) {
        TimeDist dist;
        TimeAndDist time = (TimeAndDist)((MethodTypeStatistic)this.statistic).getValue(0);
        if (column == 0) {
            dist = time.getTimeDistribution();
        } else {
            assert (column == 1);
            dist = time.getCpuTimeDistribution();
        }
        long result = 0L;
        if (row == 0) {
            result = dist.getCompiledTime() + dist.getInlinedTime() + dist.getCompiledTier1Time() + dist.getInlinedTier1Time();
        } else if (row == 1) {
            result = dist.getInterpreterTime();
        } else {
            assert (row == 2);
            result = dist.getNativeInterpreterTime() + dist.getNativeCompiledTime() + dist.getNativeInlinedTime() + dist.getNativeCompiledTier1Time() + dist.getNativeInlinedTier1Time();
        }
        return ElapsedTime.PROTOTYPE.create(result, this.getTotalTime());
    }
}

