/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.PerformanceHotspotValueSetProvider;
import com.sap.jvm.profiling.presentation.impl.typed.tbs.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.MethodTypeStatistic;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;

public class DetailedCompiledVsInterpretedProvider
extends PerformanceHotspotValueSetProvider<MethodTypeStatistic, RunningType> {
    private final boolean hasTier1Info;

    public DetailedCompiledVsInterpretedProvider(ResourceName name) {
        super(ProviderUtils.getSimpleSampleSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"methods")), I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Detailed Compiled Vs. Interpreted"), "profiling/compiled_vs_interpreted_detailed.png", name);
        this.hasTier1Info = name.getSession().getSystemInfo().tbsSupportsTierInformation();
    }

    @Override
    protected ResourceName getStatisticName() {
        ResourceName baseName = this.getResourceName().stripLastElement();
        ProfilingSession session = baseName.getSession();
        return baseName.addElement((ResourceNameElement)new Elements.CreateMethodTypeStatistic(new MethodFilter[]{new MethodFilter(ClassFilter.createAny(session, "<any>"), "<any>")}));
    }

    @Override
    public int getNrOfRows() {
        return this.hasTier1Info ? 11 : 7;
    }

    @Override
    public String getRowColorTag(int row) {
        if (this.hasTier1Info) {
            return (new String[]{"performance.graph.compiled-non-native", "performance.graph.compiled-non-native-tier-1", "performance.graph.inlined-non-native", "performance.graph.inlined-non-native-tier-1", "performance.graph.interpreted-non-native", "performance.graph.compiled-native", "performance.graph.compiled-native-tier-1", "performance.graph.inlined-native", "performance.graph.inlined-native-tier-1", "performance.graph.interpreted-native", "performance.graph.other"})[row];
        }
        return (new String[]{"performance.graph.compiled-non-native", "performance.graph.inlined-non-native", "performance.graph.interpreted-non-native", "performance.graph.compiled-native", "performance.graph.inlined-native", "performance.graph.interpreted-native", "performance.graph.other"})[row];
    }

    @Override
    public String getRowName(int row) {
        if (this.hasTier1Info) {
            return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Non-Native Tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Non-Native Tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native Tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native Tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Other")})[row];
        }
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Non-Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Native"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Other")})[row];
    }

    @Override
    public String getRowToolTip(int row) {
        if (this.hasTier1Info) {
            return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined non-native methods in tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined non-native methods in tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in interpreted non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined native methods in tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined native methods in tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in interpreted native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in other methods")})[row];
        }
        return (new String[]{I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in interpreted non-native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in compiled but not inlined native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in inlined native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in interpreted native methods"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in other methods")})[row];
    }

    @Override
    public RunningType getRowType(int row) {
        if (this.hasTier1Info) {
            switch (row) {
                case 0: {
                    return RunningType.COMPILED_NON_NATIVE;
                }
                case 1: {
                    return RunningType.COMPILED_NON_NATIVE_TIER1;
                }
                case 2: {
                    return RunningType.INLINED_NON_NATIVE;
                }
                case 3: {
                    return RunningType.INLINED_NON_NATIVE_TIER1;
                }
                case 4: {
                    return RunningType.INTERPRETED_NON_NATIVE;
                }
                case 5: {
                    return RunningType.COMPILED_NATIVE;
                }
                case 6: {
                    return RunningType.COMPILED_NATIVE_TIER1;
                }
                case 7: {
                    return RunningType.INLINED_NATIVE;
                }
                case 8: {
                    return RunningType.INLINED_NATIVE_TIER1;
                }
                case 9: {
                    return RunningType.INTERPRETED_NATIVE;
                }
                case 10: {
                    return RunningType.OTHER;
                }
            }
            assert (false);
            return null;
        }
        switch (row) {
            case 0: {
                return RunningType.COMPILED_NON_NATIVE;
            }
            case 1: {
                return RunningType.INLINED_NON_NATIVE;
            }
            case 2: {
                return RunningType.INTERPRETED_NON_NATIVE;
            }
            case 3: {
                return RunningType.COMPILED_NATIVE;
            }
            case 4: {
                return RunningType.INLINED_NATIVE;
            }
            case 5: {
                return RunningType.INTERPRETED_NATIVE;
            }
            case 6: {
                return RunningType.OTHER;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Quantity getEntry(int row, int column) {
        TimeDist dist;
        TimeAndDist time = (TimeAndDist)((MethodTypeStatistic)this.statistic).getValue(0);
        if (column == 0) {
            dist = time.getTimeDistribution();
        } else {
            assert (column == 1);
            dist = time.getCpuTimeDistribution();
        }
        long result = 0L;
        if (this.hasTier1Info) {
            if (row == 0) {
                result = dist.getCompiledTime();
            } else if (row == 1) {
                result = dist.getCompiledTier1Time();
            } else if (row == 2) {
                result = dist.getInlinedTime();
            } else if (row == 3) {
                result = dist.getInlinedTier1Time();
            } else if (row == 4) {
                result = dist.getInterpreterTime();
            } else if (row == 5) {
                result = dist.getNativeCompiledTime();
            } else if (row == 6) {
                result = dist.getNativeCompiledTier1Time();
            } else if (row == 7) {
                result = dist.getNativeInlinedTime();
            } else if (row == 8) {
                result = dist.getNativeInlinedTier1Time();
            } else if (row == 9) {
                result = dist.getNativeInterpreterTime();
            } else {
                assert (row == 10);
                result = dist.getOtherTime();
            }
        } else if (row == 0) {
            result = dist.getCompiledTime();
        } else if (row == 1) {
            result = dist.getInlinedTime();
        } else if (row == 2) {
            result = dist.getInterpreterTime();
        } else if (row == 3) {
            result = dist.getNativeCompiledTime();
        } else if (row == 4) {
            result = dist.getNativeInlinedTime();
        } else if (row == 5) {
            result = dist.getNativeInterpreterTime();
        } else {
            assert (row == 6);
            result = dist.getOtherTime();
        }
        return ElapsedTime.PROTOTYPE.create(result, this.getTotalTime());
    }
}

